*                                                                                  ;
 *    Reading in the 1990 PSID data                                                 ;
 *                                                                                  ;
 *            Karen Dynan 8/26/06                                                   ;
 *                                                                                  ;
 *    We read it all in and then output select variables to a flat                  ;
 *    file to be picked up by STATA.                                                ;
 *                                                                                  ;
 
libname psid 'F:\PSID' ;
filename rawdat 'F:\PSID\raw\fam90.raw' ;
 
 data one;
 
   infile 'F:\PSID\90FAM.DAT'  lrecl=2333 missover;
   INPUT
   V17701 1-3             V17702 4-8             V17703 9-10
   V17704 11-13           V17705 14-18           V17706 19
   V17707 20              V17708 21              V17709 22
   V17710 23              V17711 24              V17712 25
   V17713 26              V17714 27              V17715 28
   V17716 29              V17717 30-33           V17718 34-36
   V17719 37-38           V17720 39              V17721 40-41
   V17722 42              V17723 43              V17724 44-49
   V17725 50              V17726 51-56           V17727 57
   V17728 58-62           V17729 63              V17730 64-68
   V17731 69              V17732 70-73           V17733 74-78
   V17734 79              V17735 80-83           V17736 84
   V17737 85-88           V17738 89-92           V17739 93
   V17740 94-97           V17741 98              V17742 99-102
   V17743 103             V17744 104-107         V17745 108-111
   V17746 112             V17747 113-116         V17748 117
   V17749 118-121         V17750 122             V17751 123-126
   V17752 127             V17753 128-131         V17754 132
   V17755 133             V17756 134             V17757 135
   V17758 136             V17759 137             V17760 138
   V17761 139             V17762 140             V17763 141
   V17764 142             V17765 143             V17766 144
   V17767 145             V17768 146-149         V17769 150
   V17770 151-154         V17771 155             V17772 156-159
   V17773 160             V17774 161-164         V17775 165-168
   V17776 169             V17777 170-173         V17778 174
   V17779 175-178         V17780 179             V17781 180-183
   V17782 184             V17783 185-188         V17784 189
   V17785 190             V17786 191             V17787 192
   V17788 193             V17789 194             V17790 195
   V17791 196             V17792 197             V17793 198
   V17794 199             V17795 200             V17796 201
   V17797 202             V17798 203-204         V17799 205
   V17800 206-209         V17801 210             V17802 211-214
   V17803 215             V17804 216             V17805 217-219
   V17806 220             V17807 221-225         V17808 226
   V17809 227-230         V17810 231             V17811 232-235
   V17812 236             V17813 237-238         V17814 239
   V17815 240             V17816 241             V17817 242
   V17818 243             V17819 244             V17820 245
   V17821 246             V17822 247             V17823 248
   V17824 249             V17825 250             V17826 251
   V17827 252-256         V17828 257-261         V17829 262-267
   V17830 268             V17831 269-273         V17832 274-279
   V17833 280-284         V17834 285-289         V17835 290
   V17836 291-296         V17837 297             V17838 298-303
   V17839 304-309         V17840 310-314         V17841 315-319
   V17842 320-325         V17843 326-327         V17844 328-333
   V17845 334-335         V17846 336-341         V17847 342-343
   V17848 344-349         V17849 350-355         V17850 356
   V17851 357-363         V17852 364-368         V17853 369-373
   V17854 374-378         V17855 379             V17856 380-381
   V17857 382             V17858 383             V17859 384-388
   V17860 389             V17861 390-391         V17862 392-396
   V17863 397-401         V17864 402-403         V17865 404-408
   V17866 409             V17867 410-411         V17868 412-416
   V17869 417-418         V17870 419-423         V17871 424
   V17872 425-429         V17873 430-434         V17874 435-436
   V17875 437-441         V17876 442-443         V17877 444-448
   V17878 449-450         V17879 451-455         V17880 456-460
   V17881 461             V17882 462-463         V17883 464-468
   V17884 469-473         V17885 474-475         V17886 476-480
   V17887 481             V17888 482-483         V17889 484-488
   V17890 489-490         V17891 491-495         V17892 496-500
   V17893 501-505         V17894 506-507         V17895 508-512
   V17896 513-514         V17897 515-519         V17898 520-521
   V17899 522-526         V17900 527             V17901 528-532
   V17902 533             V17903 534             V17904 535
   V17905 536             V17906 537             V17907 538
   V17908 539             V17909 540             V17910 541
   V17911 542             V17912 543             V17913 544
   V17914 545             V17915 546             V17916 547
   V17917 548             V17918 549             V17919 550
   V17920 551             V17921 552             V17922 553
   V17923 554             V17924 555             V17925 556
   V17926 557             V17927 558             V17928 559
   V17929 560             V17930 561             V17931 562
   V17932 563             V17933 564             V17934 565
   V17935 566             V17936 567             V17937 568
   V17938 569             V17939 570             V17940 571
   V17941 572             V17942 573             V17943 574
   V17944 575             V17945 576             V17946 577
   V17947 578             V17948 579             V17949 580
   V17950 581             V17951 582             V17952 583
   V17953 584             V17954 585             V17955 586
   V17956 587             V17957 588             V17958 589
   V17959 590             V17960 591             V17961 592
   V17962 593             V17963 594             V17964 595
   V17965 596             V17966 597             V17967 598
   V17968 599             V17969 600             V17970 601
   V17971 602             V17972 603             V17973 604
   V17974 605             V17975 606-607         V17976 608-609
   V17977 610-615         V17978 616-617         V17979 618
   V17980 619-620         V17981 621-622         V17982 623-628
   V17983 629-630         V17984 631             V17985 632-633
   V17986 634-635         V17987 636-641         V17988 642-643
   V17989 644             V17990 645-646         V17991 647-648
   V17992 649-654         V17993 655-656         V17994 657
   V17995 658-659         V17996 660-661         V17997 662-667
   V17998 668-669         V17999 670             V18000 671-674
   V18001 675-680         V18002 681             V18003 682-686
   V18004 687             V18005 688-692         V18006 693-697
   V18007 698-702         V18008 703-707         V18009 708-712
   V18010 713-717         V18011 718-722         V18012 723-727
   V18013 728-732         V18014 733-737         V18015 738-742
   V18016 743-747         V18017 748-752         V18018 753
   V18019 754             V18020 755             V18021 756-759
   V18022 760-763         V18023 764-767         V18024 768-771
   V18025 772-775         V18026 776-779         V18027 780-783
   V18028 784-787         V18029 788-791         V18030 792-795
   V18031 796-799         V18032 800-803         V18033 804-807
   V18034 808-811         V18035 812-815         V18036 816-819
   V18037 820-823         V18038 824-827         V18039 828-831
   V18040 832-835         V18041 836-839         V18042 840-843
   V18043 844-847         V18044 848-851         V18045 852-854
   V18046 855-858         V18047 859-861         V18048 862-863
   V18049 864-865         V18050 866             V18051 867-868
   V18052 869-870         V18053 871-872         V18054 873-874
   V18055 875             V18056 876             V18057 877
   V18058 878             V18059 879             V18060 880
   V18061 881             V18062 882             V18063 883
   V18064 884             V18065 885             V18066 886
   V18067 887             V18068 888-889         V18069 890-891
   V18070 892-893         V18071 894             V18072 895
   V18073 896             V18074 897-898         V18075 899
   V18076 900             V18077 901             V18078 902
   V18079 903             V18080 904             V18081 905
   V18082 906             V18083 907             V18084 908
   V18085 909             V18086 910             V18087 911
   V18088 912-913         V18089 914             V18090 915
   V18091 916             V18092 917             V18093 918
   V18094 919-920         V18095 921             V18096 922
   V18097 923             V18098 924             V18099 925
   V18100 926             V18101 927-929         V18102 930-932
   V18103 933             V18104 934-937         V18105 938
   V18106 939-942         V18107 943-946         V18108 947-950
   V18109 951             V18110 952-955         V18111 956
   V18112 957             V18113 958             V18114 959
   V18115 960             V18116 961             V18117 962
   V18118 963             V18119 964             V18120 965-967
   V18121 968-969         V18122 970-971         V18123 972
   V18124 973-974         V18125 975-976         V18126 977
   V18127 978-979         V18128 980             V18129 981-982
   V18130 983-984         V18131 985-986         V18132 987-988
   V18133 989             V18134 990-991         V18135 992
   V18136 993-995         V18137 996-999         V18138 1000-1001
   V18139 1002            V18140 1003            V18141 1004
   V18142 1005            V18143 1006            V18144 1007
   V18145 1008            V18146 1009            V18147 1010
   V18148 1011            V18149 1012            V18150 1013
   V18151 1014            V18152 1015-1016       V18153 1017-1018
   V18154 1019            V18155 1020            V18156 1021
   V18157 1022            V18158 1023            V18159 1024
   V18160 1025            V18161 1026            V18162 1027
   V18163 1028            V18164 1029            V18165 1030
   V18166 1031            V18167 1032            V18168 1033
   V18169 1034-1036       V18170 1037-1039       V18171 1040-1043
   V18172 1044-1045       V18173 1046            V18174 1047-1048
   V18175 1049            V18176 1050            V18177 1051-1052
   V18178 1053-1054       V18179 1055            V18180 1056-1059
   V18181 1060-1061       V18182 1062            V18183 1063-1064
   V18184 1065            V18185 1066-1067       V18186 1068
   V18187 1069-1070       V18188 1071            V18189 1072-1073
   V18190 1074            V18191 1075-1076       V18192 1077
   V18193 1078-1079       V18194 1080            V18195 1081-1082
   V18196 1083-1084       V18197 1085-1086       V18198 1087
   V18199 1088            V18200 1089            V18201 1090
   V18202 1091-1093       V18203 1094-1096       V18204 1097-1100
   V18205 1101-1102       V18206 1103-1104       V18207 1105-1106
   V18208 1107-1108       V18209 1109            V18210 1110
   V18211 1111            V18212 1112            V18213 1113
   V18214 1114            V18215 1115            V18216 1116
   V18217 1117            V18218 1118            V18219 1119
   V18220 1120            V18221 1121            V18222 1122-1123
   V18223 1124-1125       V18224 1126            V18225 1127-1129
   V18226 1130-1132       V18227 1133-1136       V18228 1137-1138
   V18229 1139-1140       V18230 1141-1142       V18231 1143-1144
   V18232 1145            V18233 1146            V18234 1147
   V18235 1148            V18236 1149            V18237 1150
   V18238 1151            V18239 1152            V18240 1153
   V18241 1154            V18242 1155            V18243 1156
   V18244 1157            V18245 1158-1159       V18246 1160-1161
   V18247 1162            V18248 1163            V18249 1164
   V18250 1165            V18251 1166            V18252 1167
   V18253 1168            V18254 1169            V18255 1170
   V18256 1171-1172       V18257 1173            V18258 1174-1175
   V18259 1176-1177       V18260 1178            V18261 1179-1180
   V18262 1181-1183       V18263 1184-1186       V18264 1187
   V18265 1188            V18266 1189            V18267 1190
   V18268 1191-1192       V18269 1193-1194       V18270 1195
   V18271 1196-1197       V18272 1198-1199       V18273 1200
   V18274 1201-1202       V18275 1203            V18276 1204-1205
   V18277 1206-1207       V18278 1208-1209       V18279 1210-1211
   V18280 1212            V18281 1213-1214       V18282 1215
   V18283 1216-1218       V18284 1219-1222       V18285 1223-1224
   V18286 1225            V18287 1226            V18288 1227
   V18289 1228            V18290 1229            V18291 1230
   V18292 1231            V18293 1232            V18294 1233
   V18295 1234            V18296 1235            V18297 1236
   V18298 1237            V18299 1238-1239       V18300 1240-1241
   V18301 1242            V18302 1243            V18303 1244
   V18304 1245            V18305 1246            V18306 1247
   V18307 1248            V18308 1249            V18309 1250
   V18310 1251            V18311 1252            V18312 1253
   V18313 1254            V18314 1255            V18315 1256
   V18316 1257-1259       V18317 1260-1262       V18318 1263-1266
   V18319 1267-1268       V18320 1269            V18321 1270-1271
   V18322 1272            V18323 1273            V18324 1274-1275
   V18325 1276-1277       V18326 1278            V18327 1279-1282
   V18328 1283-1284       V18329 1285            V18330 1286-1287
   V18331 1288            V18332 1289-1290       V18333 1291
   V18334 1292-1293       V18335 1294            V18336 1295-1296
   V18337 1297            V18338 1298-1299       V18339 1300
   V18340 1301-1302       V18341 1303            V18342 1304-1305
   V18343 1306-1307       V18344 1308-1309       V18345 1310
   V18346 1311            V18347 1312            V18348 1313
   V18349 1314-1316       V18350 1317-1319       V18351 1320-1323
   V18352 1324-1325       V18353 1326-1327       V18354 1328-1329
   V18355 1330-1331       V18356 1332            V18357 1333
   V18358 1334            V18359 1335            V18360 1336
   V18361 1337            V18362 1338            V18363 1339
   V18364 1340            V18365 1341            V18366 1342
   V18367 1343            V18368 1344            V18369 1345-1346
   V18370 1347-1348       V18371 1349            V18372 1350-1352
   V18373 1353-1355       V18374 1356-1359       V18375 1360-1361
   V18376 1362-1363       V18377 1364-1365       V18378 1366-1367
   V18379 1368            V18380 1369            V18381 1370
   V18382 1371            V18383 1372            V18384 1373
   V18385 1374            V18386 1375            V18387 1376
   V18388 1377            V18389 1378            V18390 1379
   V18391 1380            V18392 1381-1382       V18393 1383-1384
   V18394 1385            V18395 1386            V18396 1387-1388
   V18397 1389            V18398 1390            V18399 1391
   V18400 1392            V18401 1393            V18402 1394
   V18403 1395-1397       V18404 1398-1400       V18405 1401
   V18406 1402-1405       V18407 1406            V18408 1407-1410
   V18409 1411-1414       V18410 1415-1418       V18411 1419
   V18412 1420-1423       V18413 1424            V18414 1425
   V18415 1426            V18416 1427            V18417 1428
   V18418 1429            V18419 1430            V18420 1431
   V18421 1432            V18422 1433-1435       V18423 1436-1437
   V18424 1438-1439       V18425 1440            V18426 1441-1442
   V18427 1443-1444       V18428 1445            V18429 1446-1447
   V18430 1448            V18431 1449-1450       V18432 1451-1452
   V18433 1453-1454       V18434 1455-1456       V18435 1457
   V18436 1458-1459       V18437 1460            V18438 1461-1463
   V18439 1464-1467       V18440 1468-1469       V18441 1470
   V18442 1471            V18443 1472            V18444 1473
   V18445 1474            V18446 1475            V18447 1476
   V18448 1477            V18449 1478            V18450 1479
   V18451 1480            V18452 1481            V18453 1482
   V18454 1483-1484       V18455 1485-1486       V18456 1487
   V18457 1488            V18458 1489            V18459 1490
   V18460 1491            V18461 1492            V18462 1493
   V18463 1494            V18464 1495            V18465 1496
   V18466 1497            V18467 1498            V18468 1499
   V18469 1500            V18470 1501            V18471 1502-1504
   V18472 1505-1507       V18473 1508-1511       V18474 1512-1513
   V18475 1514            V18476 1515-1516       V18477 1517
   V18478 1518            V18479 1519-1520       V18480 1521-1522
   V18481 1523            V18482 1524-1527       V18483 1528-1529
   V18484 1530            V18485 1531-1532       V18486 1533
   V18487 1534-1535       V18488 1536            V18489 1537-1538
   V18490 1539            V18491 1540-1541       V18492 1542
   V18493 1543-1544       V18494 1545            V18495 1546-1547
   V18496 1548            V18497 1549-1550       V18498 1551-1552
   V18499 1553-1554       V18500 1555            V18501 1556
   V18502 1557            V18503 1558            V18504 1559-1561
   V18505 1562-1564       V18506 1565-1568       V18507 1569-1570
   V18508 1571-1572       V18509 1573-1574       V18510 1575-1576
   V18511 1577            V18512 1578            V18513 1579
   V18514 1580            V18515 1581            V18516 1582
   V18517 1583            V18518 1584            V18519 1585
   V18520 1586            V18521 1587            V18522 1588
   V18523 1589            V18524 1590-1591       V18525 1592-1593
   V18526 1594            V18527 1595-1597       V18528 1598-1600
   V18529 1601-1604       V18530 1605-1606       V18531 1607-1608
   V18532 1609-1610       V18533 1611-1612       V18534 1613
   V18535 1614            V18536 1615            V18537 1616
   V18538 1617            V18539 1618            V18540 1619
   V18541 1620            V18542 1621            V18543 1622
   V18544 1623            V18545 1624            V18546 1625
   V18547 1626-1627       V18548 1628-1629       V18549 1630
   V18550 1631            V18551 1632            V18552 1633
   V18553 1634            V18554 1635            V18555 1636
   V18556 1637            V18557 1638            V18558 1639-1640
   V18559 1641            V18560 1642-1643       V18561 1644-1645
   V18562 1646            V18563 1647-1648       V18564 1649-1651
   V18565 1652-1654       V18566 1655            V18567 1656
   V18568 1657            V18569 1658            V18570 1659-1660
   V18571 1661-1662       V18572 1663            V18573 1664-1665
   V18574 1666-1667       V18575 1668            V18576 1669-1670
   V18577 1671            V18578 1672-1673       V18579 1674-1675
   V18580 1676-1677       V18581 1678-1679       V18582 1680
   V18583 1681-1682       V18584 1683            V18585 1684-1686
   V18586 1687-1690       V18587 1691-1692       V18588 1693
   V18589 1694            V18590 1695            V18591 1696
   V18592 1697            V18593 1698            V18594 1699
   V18595 1700            V18596 1701            V18597 1702
   V18598 1703            V18599 1704            V18600 1705
   V18601 1706-1707       V18602 1708-1709       V18603 1710
   V18604 1711            V18605 1712            V18606 1713
   V18607 1714            V18608 1715            V18609 1716
   V18610 1717            V18611 1718            V18612 1719
   V18613 1720            V18614 1721            V18615 1722
   V18616 1723            V18617 1724            V18618 1725-1727
   V18619 1728-1730       V18620 1731-1734       V18621 1735-1736
   V18622 1737            V18623 1738-1739       V18624 1740
   V18625 1741            V18626 1742-1743       V18627 1744-1745
   V18628 1746            V18629 1747-1750       V18630 1751-1752
   V18631 1753            V18632 1754-1755       V18633 1756
   V18634 1757-1758       V18635 1759            V18636 1760-1761
   V18637 1762            V18638 1763-1764       V18639 1765
   V18640 1766-1767       V18641 1768            V18642 1769-1770
   V18643 1771            V18644 1772-1773       V18645 1774-1775
   V18646 1776-1777       V18647 1778            V18648 1779
   V18649 1780            V18650 1781            V18651 1782-1784
   V18652 1785-1787       V18653 1788-1791       V18654 1792-1793
   V18655 1794-1795       V18656 1796-1797       V18657 1798-1799
   V18658 1800            V18659 1801            V18660 1802
   V18661 1803            V18662 1804            V18663 1805
   V18664 1806            V18665 1807            V18666 1808
   V18667 1809            V18668 1810            V18669 1811
   V18670 1812            V18671 1813-1814       V18672 1815-1816
   V18673 1817            V18674 1818-1820       V18675 1821-1823
   V18676 1824-1827       V18677 1828-1829       V18678 1830-1831
   V18679 1832-1833       V18680 1834-1835       V18681 1836
   V18682 1837            V18683 1838            V18684 1839
   V18685 1840            V18686 1841            V18687 1842
   V18688 1843            V18689 1844            V18690 1845
   V18691 1846            V18692 1847            V18693 1848
   V18694 1849-1850       V18695 1851-1852       V18696 1853
   V18697 1854-1855       V18698 1856-1857       V18699 1858
   V18700 1859-1863       V18701 1864            V18702 1865-1870
   V18703 1871            V18704 1872-1873       V18705 1874
   V18706 1875            V18707 1876            V18708 1877
   V18709 1878-1883       V18710 1884-1889       V18711 1890
   V18712 1891            V18713 1892-1893       V18714 1894-1895
   V18715 1896-1897       V18716 1898-1899       V18717 1900
   V18718 1901            V18719 1902            V18720 1903
   V18721 1904            V18722 1905            V18723 1906
   V18724 1907            V18725 1908            V18726 1909
   V18727 1910            V18728 1911            V18729 1912
   V18730 1913            V18731 1914            V18732 1915
   V18733 1916            V18734 1917            V18735 1918
   V18736 1919            V18737 1920-1921       V18738 1922
   V18739 1923            V18740 1924-1925       V18741 1926
   V18742 1927            V18743 1928-1929       V18744 1930
   V18745 1931            V18746 1932-1933       V18747 1934
   V18748 1935            V18749 1936            V18750 1937
   V18751 1938            V18752 1939            V18753 1940-1941
   V18754 1942-1943       V18755 1944-1945       V18756 1946-1947
   V18757 1948-1949       V18758 1950-1951       V18759 1952
   V18760 1953-1954       V18761 1955            V18762 1956
   V18763 1957-1958       V18764 1959-1960       V18765 1961
   V18766 1962            V18767 1963            V18768 1964-1965
   V18769 1966-1967       V18770 1968-1969       V18771 1970
   V18772 1971-1972       V18773 1973-1974       V18774 1975-1976
   V18775 1977            V18776 1978-1979       V18777 1980-1981
   V18778 1982-1983       V18779 1984-1985       V18780 1986-1987
   V18781 1988-1989       V18782 1990            V18783 1991-1992
   V18784 1993-1995       V18785 1996-1997       V18786 1998-2000
   V18787 2001            V18788 2002            V18789 2003
   V18790 2004            V18791 2005-2006       V18792 2007-2009
   V18793 2010            V18794 2011            V18795 2012
   V18796 2013            V18797 2014            V18798 2015
   V18799 2016            V18800 2017            V18801 2018-2019
   V18802 2020            V18803 2021            V18804 2022-2023
   V18805 2024            V18806 2025            V18807 2026-2027
   V18808 2028            V18809 2029            V18810 2030-2031
   V18811 2032            V18812 2033            V18813 2034
   V18814 2035            V18815 2036            V18816 2037
   V18817 2038            V18818 2039-2040       V18819 2041-2042
   V18820 2043-2044       V18821 2045-2046       V18822 2047-2048
   V18823 2049-2050       V18824 2051-2052       V18825 2053-2054
   V18826 2055-2056       V18827 2057-2058       V18828 2059
   V18829 2060-2061       V18830 2062-2063       V18831 2064
   V18832 2065            V18833 2066-2067       V18834 2068-2069
   V18835 2070-2071       V18836 2072            V18837 2073
   V18838 2074            V18839 2075-2076       V18840 2077-2078
   V18841 2079-2080       V18842 2081-2082       V18843 2083
   V18844 2084-2085       V18845 2086-2087       V18846 2088-2089
   V18847 2090-2091       V18848 2092            V18849 2093-2094
   V18850 2095-2096       V18851 2097-2098       V18852 2099-2100
   V18853 2101-2102       V18854 2103-2104       V18855 2105-2106
   V18856 2107            V18857 2108-2109       V18858 2110
   V18859 2111            V18860 2112            V18861 2113-2114
   V18862 2115-2120       V18863 2121-2122       V18864 2123-2127
   V18865 2128-2129       V18866 2130-2134       V18867 2135-2136
   V18868 2137-2141       V18869 2142-2143       V18870 2144-2148
   V18871 2149-2150       V18872 2151-2155       V18873 2156-2157
   V18874 2158-2163       V18875 2164-2170       V18876 2171-2173
   V18877 2174-2176       V18878 2177-2182       V18879 2183-2185
   V18880 2186-2188       V18881 2189-2193 .2    V18882 2194-2198
   V18883 2199-2203 .2    V18884 2204-2208       V18885 2209-2212 .2
   V18886 2213-2216       V18887 2217-2220 .2    V18888 2221-2224 .2
   V18889 2225            V18890 2226-2227       V18891 2228-2230
   V18892 2231-2232       V18893 2233            V18894 2234
   V18895 2235            V18896 2236-2237       V18897 2238-2239
   V18898 2240            V18899 2241            V18900 2242
   V18901 2243            V18902 2244            V18903 2245
   V18904 2246            V18905 2247            V18906 2248
   V18907 2249            V18908 2250            V18909 2251
   V18910 2252            V18911 2253            V18912 2254
   V18913 2255            V18914 2256            V18915 2257-2258
   V18916 2259            V18917 2260            V18918 2261
   V18919 2262-2263       V18920 2264-2265       V18921 2266
   V18922 2267            V18923 2268-2272       V18924 2273-2277
   V18925 2278            V18926 2279-2280       V18927 2281-2285
   V18928 2286            V18929 2287-2288       V18930 2289-2293
   V18931 2294            V18932 2295-2296       V18933 2297-2301
   V18934 2302            V18935 2303-2304       V18936 2305-2309
   V18937 2310            V18938 2311            V18939 2312
   V18940 2313            V18941 2314            V18942 2315
   V18943 2316-2321 .3    V18944 2322-2327 .3    V18945 2328-2333 .3;

* SAS LABEL STATEMENT;

LABEL
   V17701 = "STUDY NUMBER (714)    90"
   V17702 = "IND. 1990 ID"
   V17703 = "CURRENT STATE         90"
   V17704 = "CURRENT COUNTY        90"
   V17705 = "CURRENT STATE+CNTY    90"
   V17706 = "SIZE LGST CITY/COUNTY 90"
   V17707 = "SPLITOFF INDICATOR    90"
   V17708 = "WHETHER REFUSED       90"
   V17709 = "MODE OF INTERVIEW     90"
   V17710 = "FAM COMP CHANGE       90"
   V17711 = "NUMBER MOVED IN       90"
   V17712 = "WHO MOVED IN          90"
   V17713 = "NUMBER MOVED OUT      90"
   V17714 = "WHO MOVED OUT         90"
   V17715 = "CURRENT FAM COMP      90"
   V17716 = "CURRENT HSEHOLD COMP  90"
   V17717 = "68 ID# OF HOUSEHOLDER 90"
   V17718 = "PERS# OF HOUSEHOLDER  90"
   V17719 = "AGE OF HOUSEHOLDER    90"
   V17720 = "SEX OF HOUSEHOLDER    90"
   V17721 = "REL HHOLDER TO FU HD  90"
   V17722 = "QUALITY OF MATCH      90"
   V17723 = "TYPE INSTITUTION      90"
   V17724 = "1990 HOUSE VALUE  (A16)"
   V17725 = "ACC 90 HOUSE VALUE"
   V17726 = "1990 REM MORT PRIN (A20)"
   V17727 = "ACC REM MORT PRIN"
   V17728 = "TOTAL ANN MRTG PMT (A21)"
   V17729 = "ACC TOT ANN MRTG PMT"
   V17730 = "90 ANN PROP TAX (A17)"
   V17731 = "ACC ANN PROP TAX"
   V17732 = "ANN HOMEOWNER INS (A18)"
   V17733 = "ANN RENT (A27)"
   V17734 = "ACC ANN RENT"
   V17735 = "ANN VAL FREE HSNG (A33)"
   V17736 = "ACC ANN VAL FREE HSNG"
   V17737 = "GOV SUBSIDY OF HTG (A14)"
   V17738 = "HD MAIN JOB WRKHRS 89"
   V17739 = "ACC HD 89 MAIN JOB WRKHR"
   V17740 = "HD OVERTIME WRKHRS 89"
   V17741 = "ACC HD 89 OVERTIME WRKHR"
   V17742 = "HD XTRA JOB WRKHRS 89"
   V17743 = "ACC HD 89 XTRA JOB WRKHR"
   V17744 = "HD ANN WRK HRS IN 89"
   V17745 = "HD HRS WRK LOST OTR ILL"
   V17746 = "ACC HD HR LOST OTR ILL"
   V17747 = "HD HRS WRK LOST OWN ILL"
   V17748 = "ACC HD HRS LOST OWN ILL"
   V17749 = "HD STRIKE HOURS 89"
   V17750 = "ACC HD STRIKE HRS 89"
   V17751 = "HD UNEMP HRS 89"
   V17752 = "ACC 89 HD UNEMP HRS"
   V17753 = "HD HRS OUT LBR FORCE 89"
   V17754 = "ACC 89 HD HR OUT LBR FRC"
   V17755 = "HD UNEMP/OUT LBR JAN 89"
   V17756 = "HD UNEMP/OUT LBR FEB 89"
   V17757 = "HD UNEMP/OUT LBR MAR 89"
   V17758 = "HD UNEMP/OUT LBR APR 89"
   V17759 = "HD UNEMP/OUT LBR MAY 89"
   V17760 = "HD UNEMP/OUT LBR JUN 89"
   V17761 = "HD UNEMP/OUT LBR JUL 89"
   V17762 = "HD UNEMP/OUT LBR AUG 89"
   V17763 = "HD UNEMP/OUT LBR SEP 89"
   V17764 = "HD UNEMP/OUT LBR OCT 89"
   V17765 = "HD UNEMP/OUT LBR NOV 89"
   V17766 = "HD UNEMP/OUT LBR DEC 89"
   V17767 = "WIFE IN FU?"
   V17768 = "WF MAIN JOB WRKHRS 89"
   V17769 = "ACC WF 89 MAIN JOB WRKHR"
   V17770 = "WF OVERTIME WRKHRS 89"
   V17771 = "ACC WF 89 OVERTIME WRKHR"
   V17772 = "WF XTRA JOB WRKHRS 89"
   V17773 = "ACC WF 89 XTRA JOB WRKHR"
   V17774 = "WF ANN WRK HRS IN 89"
   V17775 = "WF HRS WRK LOST OTR ILL"
   V17776 = "ACC WF HR LOST OTR ILL"
   V17777 = "WF HRS WRK LOST OWN ILL"
   V17778 = "ACC WF HRS LOST OWN ILL"
   V17779 = "WF STRIKE HOURS 89"
   V17780 = "ACC WF STRIKE HRS 89"
   V17781 = "WF UNEMP HRS 89"
   V17782 = "ACC WF UNEMP HRS 89"
   V17783 = "WF HRS OUT LBR FORCE 89"
   V17784 = "ACC WF 89 HR OUT LBR FRC"
   V17785 = "WF UNEMP/OUT LBR JAN 89"
   V17786 = "WF UNEMP/OUT LBR FEB 89"
   V17787 = "WF UNEMP/OUT LBR MAR 89"
   V17788 = "WF UNEMP/OUT LBR APR 89"
   V17789 = "WF UNEMP/OUT LBR MAY 89"
   V17790 = "WF UNEMP/OUT LBR JUN 89"
   V17791 = "WF UNEMP/OUT LBR JUL 89"
   V17792 = "WF UNEMP/OUT LBR AUG 89"
   V17793 = "WF UNEMP/OUT LBR SEP 89"
   V17794 = "WF UNEMP/OUT LBR OCT 89"
   V17795 = "WF UNEMP/OUT LBR NOV 89"
   V17796 = "WF UNEMP/OUT LBR DEC 89"
   V17797 = "# MAJOR ADULTS"
   V17798 = "1990 FAMILY SIZE"
   V17799 = "# REQUIRED ROOMS"
   V17800 = "WIFE ANN HOUSEWORK  (F2)"
   V17801 = "ACC WIFE ANN HOUSEWORK"
   V17802 = "HEAD ANN HOUSEWORK  (F3)"
   V17803 = "ACC HEAD ANN HOUSEWORK"
   V17804 = "# IN HH GOT FD ST LST MO"
   V17805 = "VALUE FD ST LST MO (F10)"
   V17806 = "ACC VALUE FD ST LST MO"
   V17807 = "ANN FD COST-EXC FD ST"
   V17808 = "ACC ANN FD COST EX FD ST"
   V17809 = "ANN FD COST-EAT OUT"
   V17810 = "ACC EAT OUT FD COST"
   V17811 = "VALUE FD ST 89     (F21)"
   V17812 = "ACC VALUE FD ST 89"
   V17813 = "# MOS USED FD ST 89(F10)"
   V17814 = "WTR USED FD ST JAN 89"
   V17815 = "WTR USED FD ST FEB 89"
   V17816 = "WTR USED FD ST MAR 89"
   V17817 = "WTR USED FD ST APR 89"
   V17818 = "WTR USED FD ST MAY 89"
   V17819 = "WTR USED FD ST JUN 89"
   V17820 = "WTR USED FD ST JUL 89"
   V17821 = "WTR USED FD ST AUG 89"
   V17822 = "WTR USED FD ST SEP 89"
   V17823 = "WTR USED FD ST OCT 89"
   V17824 = "WTR USED FD ST NOV 89"
   V17825 = "WTR USED FD ST DEC 89"
   V17826 = "HD/WF HAVE TXBL Y?"
   V17827 = "LABOR PART FARM Y 89"
   V17828 = "LABOR PART BUS Y 89"
   V17829 = "HEAD 89 WAGES"
   V17830 = "ACC HEAD 89 WAGES"
   V17831 = "HD BONUS/OT/COMM 89"
   V17832 = "HD PROF PRAC/TRADE 89"
   V17833 = "LABOR PT MKT GARDEN 89"
   V17834 = "LABOR PT ROOMERS 89"
   V17835 = "ACC HD LABOR Y EXC WAGES"
   V17836 = "WIFE 89 LABOR/WAGE"
   V17837 = "ACC WF 89 LABOR/WAGE"
   V17838 = "ASSET PART FARM Y 89"
   V17839 = "ASSET PART BUS Y 89"
   V17840 = "ASSET PT MKT GARDN 89"
   V17841 = "ASSET PT ROOMERS 89"
   V17842 = "WF PT ASSET INCOME 89"
   V17843 = "HD # MO RECD RENT 89"
   V17844 = "HD RENT 89"
   V17845 = "HD # MO RECD INT/DIV 89"
   V17846 = "HD INT/DIVIDENDS 89"
   V17847 = "HD #MO RECD ALIMONY 89"
   V17848 = "ALIMONY Y HEAD 89"
   V17849 = "WF 89 OTHER ASSET Y"
   V17850 = "ACC H+W 89 ASSET Y"
   V17851 = "H+W 89 TAXABLE Y"
   V17852 = "H+W 89 SUPP OTR NONFU"
   V17853 = "H+W CHLD SUPPORT PAID 89"
   V17854 = "H+W ALIMONY PAID 89"
   V17855 = "XTRA XMPTS FOR BLIND"
   V17856 = "H+W TOTAL 89 EXEMPTION"
   V17857 = "1989 TAX TABLE USED-H+W"
   V17858 = "HD/WF REC TRANSFER Y 89?"
   V17859 = "HD 89 ADC/AFDC"
   V17860 = "ACC HD 89 ADC/AFDC"
   V17861 = "HD # MO RECEIVE SSI 89"
   V17862 = "HD 89 SSI"
   V17863 = "HD 89 OTR WELFARE"
   V17864 = "HD #MO RECD SOC SEC 89"
   V17865 = "HD 89 SOCIAL SECURITY"
   V17866 = "HD TYPE SOC SEC 89"
   V17867 = "HD #MO REC VA PENSION 89"
   V17868 = "HD 89 VA PENSION"
   V17869 = "HD #MO RECD OTR RET 89"
   V17870 = "HD OTHER RETIREMENT 89"
   V17871 = "HD # OTH PENS RCD 89"
   V17872 = "HD 89 UNEMP COMP"
   V17873 = "HD 89 WORKERS COMP"
   V17874 = "HD #MO REC CHILD SUPP 89"
   V17875 = "HD 89 CHILD SUPPORT"
   V17876 = "HD #MO REC HLP FR REL 89"
   V17877 = "HD 89 HELP FROM RELS"
   V17878 = "HD #MO REC OTR TRAN Y 89"
   V17879 = "HD 89 OTHER TRANSFER Y"
   V17880 = "WF 89 ADC/AFDC"
   V17881 = "ACC WF 89 ADC/AFDC"
   V17882 = "WF # MO RECEIVE SSI 89"
   V17883 = "WF 89 SSI"
   V17884 = "WF 89 OTR WELFARE"
   V17885 = "WF #MO RECD SOC SEC 89"
   V17886 = "WF 89 SOCIAL SECURITY"
   V17887 = "WF TYPE SOC SEC 89"
   V17888 = "WF #MO REC VA PENSION 89"
   V17889 = "WF 89 VA PENSION"
   V17890 = "WF #MO RECD OTR RET 89"
   V17891 = "WF OTHER RETIREMENT 89"
   V17892 = "WF 89 UNEMP COMP"
   V17893 = "WF 89 WORKERS COMP"
   V17894 = "WF #MO REC CHILD SUPP 89"
   V17895 = "WF 89 CHILD SUPPORT"
   V17896 = "WF #MO REC HLP FR REL 89"
   V17897 = "WF 89 HELP FROM RELS"
   V17898 = "WF #MO REC OTR TRAN Y 89"
   V17899 = "WF 89 OTHER TRANSFER Y"
   V17900 = "ACC H+W 89 TRANS EXC ADC"
   V17901 = "H+W 89 TOT TRANSFER Y"
   V17902 = "H+W RECD ADC/AFDC JAN 89"
   V17903 = "H+W RECD ADC/AFDC FEB 89"
   V17904 = "H+W RECD ADC/AFDC MAR 89"
   V17905 = "H+W RECD ADC/AFDC APR 89"
   V17906 = "H+W RECD ADC/AFDC MAY 89"
   V17907 = "H+W RECD ADC/AFDC JUN 89"
   V17908 = "H+W RECD ADC/AFDC JUL 89"
   V17909 = "H+W RECD ADC/AFDC AUG 89"
   V17910 = "H+W RECD ADC/AFDC SEP 89"
   V17911 = "H+W RECD ADC/AFDC OCT 89"
   V17912 = "H+W RECD ADC/AFDC NOV 89"
   V17913 = "H+W RECD ADC/AFDC DEC 89"
   V17914 = "H+W REC OTR WELFR JAN 89"
   V17915 = "H+W REC OTR WELFR FEB 89"
   V17916 = "H+W REC OTR WELFR MAR 89"
   V17917 = "H+W REC OTR WELFR APR 89"
   V17918 = "H+W REC OTR WELFR MAY 89"
   V17919 = "H+W REC OTR WELFR JUN 89"
   V17920 = "H+W REC OTR WELFR JUL 89"
   V17921 = "H+W REC OTR WELFR AUG 89"
   V17922 = "H+W REC OTR WELFR SEP 89"
   V17923 = "H+W REC OTR WELFR OCT 89"
   V17924 = "H+W REC OTR WELFR NOV 89"
   V17925 = "H+W REC OTR WELFR DEC 89"
   V17926 = "HD REC UNEMP COMP JAN 89"
   V17927 = "HD REC UNEMP COMP FEB 89"
   V17928 = "HD REC UNEMP COMP MAR 89"
   V17929 = "HD REC UNEMP COMP APR 89"
   V17930 = "HD REC UNEMP COMP MAY 89"
   V17931 = "HD REC UNEMP COMP JUN 89"
   V17932 = "HD REC UNEMP COMP JUL 89"
   V17933 = "HD REC UNEMP COMP AUG 89"
   V17934 = "HD REC UNEMP COMP SEP 89"
   V17935 = "HD REC UNEMP COMP OCT 89"
   V17936 = "HD REC UNEMP COMP NOV 89"
   V17937 = "HD REC UNEMP COMP DEC 89"
   V17938 = "WF REC UNEMP COMP JAN 89"
   V17939 = "WF REC UNEMP COMP FEB 89"
   V17940 = "WF REC UNEMP COMP MAR 89"
   V17941 = "WF REC UNEMP COMP APR 89"
   V17942 = "WF REC UNEMP COMP MAY 89"
   V17943 = "WF REC UNEMP COMP JUN 89"
   V17944 = "WF REC UNEMP COMP JUL 89"
   V17945 = "WF REC UNEMP COMP AUG 89"
   V17946 = "WF REC UNEMP COMP SEP 89"
   V17947 = "WF REC UNEMP COMP OCT 89"
   V17948 = "WF REC UNEMP COMP NOV 89"
   V17949 = "WF REC UNEMP COMP DEC 89"
   V17950 = "HD REC WORKR COMP JAN 89"
   V17951 = "HD REC WORKR COMP FEB 89"
   V17952 = "HD REC WORKR COMP MAR 89"
   V17953 = "HD REC WORKR COMP APR 89"
   V17954 = "HD REC WORKR COMP MAY 89"
   V17955 = "HD REC WORKR COMP JUN 89"
   V17956 = "HD REC WORKR COMP JUL 89"
   V17957 = "HD REC WORKR COMP AUG 89"
   V17958 = "HD REC WORKR COMP SEP 89"
   V17959 = "HD REC WORKR COMP OCT 89"
   V17960 = "HD REC WORKR COMP NOV 89"
   V17961 = "HD REC WORKR COMP DEC 89"
   V17962 = "WF REC WORKR COMP JAN 89"
   V17963 = "WF REC WORKR COMP FEB 89"
   V17964 = "WF REC WORKR COMP MAR 89"
   V17965 = "WF REC WORKR COMP APR 89"
   V17966 = "WF REC WORKR COMP MAY 89"
   V17967 = "WF REC WORKR COMP JUN 89"
   V17968 = "WF REC WORKR COMP JUL 89"
   V17969 = "WF REC WORKR COMP AUG 89"
   V17970 = "WF REC WORKR COMP SEP 89"
   V17971 = "WF REC WORKR COMP OCT 89"
   V17972 = "WF REC WORKR COMP NOV 89"
   V17973 = "WF REC WORKR COMP DEC 89"
   V17974 = "OFUM REC TXBL Y 89?"
   V17975 = "SEQ# 1ST OFUM W TXBL Y"
   V17976 = "P PRORAT TXBL Y 1ST OFUM"
   V17977 = "TXBL Y 1ST XTRA EARNER"
   V17978 = "# EXEMP 1ST XTRA EARNER"
   V17979 = "TAX TABLE 1ST XTRA EARNR"
   V17980 = "SEQ# 2ND OFUM W TXBL Y"
   V17981 = "P PRORAT TXBL Y 2ND OFUM"
   V17982 = "TXBL Y 2ND XTRA EARNER"
   V17983 = "# EXEMP 2ND XTRA EARNER"
   V17984 = "TAX TABLE 2ND XTRA EARNR"
   V17985 = "SEQ# 3RD OFUM W TXBL Y"
   V17986 = "P PRORAT TXBL Y 3RD OFUM"
   V17987 = "TXBL Y 3RD XTRA EARNER"
   V17988 = "# EXEMP 3RD XTRA EARNER"
   V17989 = "TAX TABLE 3RD XTRA EARNR"
   V17990 = "SEQ# 4TH OFUM W TXBL Y"
   V17991 = "P PRORAT TXBL Y 4TH OFUM"
   V17992 = "TXBL Y 4TH XTRA EARNER"
   V17993 = "# EXEMP 4TH XTRA EARNER"
   V17994 = "TAX TABLE 4TH XTRA EARNR"
   V17995 = "SEQ# 5TH OFUM W TXBL Y"
   V17996 = "P PRORAT TXBL Y 5TH OFUM"
   V17997 = "TXBL Y 5TH XTRA EARNER"
   V17998 = "# EXEMP 5TH XTRA EARNER"
   V17999 = "TAX TABLE 5TH XTRA EARNR"
   V18000 = "OFUM 89 ANN WRK HRS"
   V18001 = "OFUM 89 TOT ANN TXBL Y"
   V18002 = "ACC OFUM ANN TXBL Y 89"
   V18003 = "OFUM 89 ASSET Y"
   V18004 = "OFUM REC TRANSFER Y?"
   V18005 = "OFUM 89 ADC/AFDC"
   V18006 = "OFUM 89 SSI"
   V18007 = "OFUM 89 OTHER WELFARE"
   V18008 = "OFUM 89 SOC SECURITY"
   V18009 = "OFUM 89 VA PAYMENTS"
   V18010 = "OFUM 89 OTR RETIREMENT"
   V18011 = "OFUM 89 UNEMP COMP"
   V18012 = "OFUM 89 WORKERS COMP"
   V18013 = "OFUM 89 CHILD SUPPORT"
   V18014 = "OFUM 89 HELP FROM RELS"
   V18015 = "OFUM 89 MISC TRANSFERS"
   V18016 = "NOPRO TOT TRANS Y OFUM89"
   V18017 = "PRO TOT TRANS Y OFUM 89"
   V18018 = "ACC OFUM 89 TRANSFERS"
   V18019 = "# OFUM Y RECEIVERS 89"
   V18020 = "# OFUM LABOR Y RECRS 89"
   V18021 = "1968 ID"
   V18022 = "1969 ID"
   V18023 = "1970 ID"
   V18024 = "1971 ID"
   V18025 = "1972 ID"
   V18026 = "1973 ID"
   V18027 = "1974 ID"
   V18028 = "1975 ID"
   V18029 = "1976 ID"
   V18030 = "1977 ID"
   V18031 = "1978 ID"
   V18032 = "1979 ID"
   V18033 = "1980 ID"
   V18034 = "1981 ID"
   V18035 = "1982 ID"
   V18036 = "1983 ID"
   V18037 = "1984 ID"
   V18038 = "1985 ID"
   V18039 = "1986 ID"
   V18040 = "1987 ID"
   V18041 = "1988 ID"
   V18042 = "1989 ID"
   V18043 = "LATINO TEMPLE CASE ID"
   V18044 = "INTERVIEWER ID # 1990"
   V18045 = "INTERVIEWER INTVIEW #"
   V18046 = "DATE OF 1990 IW"
   V18047 = "LENGTH OF 1990 IW"
   V18048 = "# IN FU"
   V18049 = "AGE OF 1990 HEAD"
   V18050 = "SEX OF 1990 HEAD"
   V18051 = "AGE OF 1990 WIFE"
   V18052 = "# CHILDREN IN FU"
   V18053 = "AGE YOUNGEST CHILD"
   V18054 = "# NONFU SHARING HU"
   V18055 = "A3 MARITAL STATUS"
   V18056 = "A4 TYPE DU"
   V18057 = "A6 LIVE IN ELDERLY HSNG"
   V18058 = "A7 TYPE ELDERLY HSNG"
   V18059 = "A8 PROVIDE XTRA SERVICES"
   V18060 = "A9A PROVIDE NURSING CARE"
   V18061 = "A9B PROVIDE TRANSPORTN"
   V18062 = "A9C PROVIDE COMMON MEALS"
   V18063 = "A9D PROVIDE MAID SERVICE"
   V18064 = "A9E PROVIDE LAUNDRY"
   V18065 = "A9F PROVIDE RECREATION"
   V18066 = "A9G PROVIDE OTHER SERVCS"
   V18067 = "A10 SERVICES INCLUDED"
   V18068 = "A11 TYPE HEATING #1"
   V18069 = "A11 TYPE HEATING #2"
   V18070 = "A12 ACTUAL # ROOMS"
   V18071 = "A13 RECD GOVT HTG SUBSDY"
   V18072 = "A15 OWN/RENT OR WHAT"
   V18073 = "A19 HAVE MORTGAGE?"
   V18074 = "A23 #YRS LEFT TO PAY MTG"
   V18075 = "A24 SECOND MORTGAGE?"
   V18076 = "A25 MTG INCL PROP TAXES"
   V18077 = "A26 MTG INCL INS PREM"
   V18078 = "A28 FURNISHED APT/HOUSE"
   V18079 = "A29 RENT INCL HEAT"
   V18080 = "A30 IN PUBLIC OWND PROJ?"
   V18081 = "A31 GOVT PAY PART RENT?"
   V18082 = "A32 WHY NOT OWN/RENT"
   V18083 = "A34 IN PUBLIC OWND PROJ?"
   V18084 = "A35 GOVT PAY ALL RENT?"
   V18085 = "A36 HAVE AIR CONDITNG"
   V18086 = "A37 A/C ALL OR SOME ROOM"
   V18087 = "A38 MOVED SINCE SPG 89?"
   V18088 = "A39 MONTH MOVED"
   V18089 = "A40 WHY MOVED"
   V18090 = "A41 WTR MIGHT MOVE"
   V18091 = "A42 LIKELIHOOD OF MOVING"
   V18092 = "A43 WHY MIGHT MOVE"
   V18093 = "B1 EMPLOYMENT STATUS-HD"
   V18094 = "B2 YEAR RETIRED   (HD-R)"
   V18095 = "B3 WORK FOR MONEY?(HD-E)"
   V18096 = "B4 WORK SELF/OTR? (HD-E)"
   V18097 = "B5 CORP/UNCORP BUS(HD-E)"
   V18098 = "B6 WORK FOR GOVT? (HD-E)"
   V18099 = "B7 JOB NOW UNION?  (H-E)"
   V18100 = "B8 BELONG UNION?  (HD-E)"
   V18101 = "B9-10 MAIN OCC:3 DIG H-E"
   V18102 = "B11 MAIN IND:3 DIGT(H-E)"
   V18103 = "B12 SLRY/HRLY/OTR  (H-E)"
   V18104 = "B13 PAY/HR-SALARY (HD-E)"
   V18105 = "B14 WTR SAL PD OT (HD-E)"
   V18106 = "B15 PAY/HR-SLRYOT (HD-E)"
   V18107 = "B16 PAY/HR-HOURLY (HD-E)"
   V18108 = "B17 PAY/HR-HRLY OT (H-E)"
   V18109 = "B18 HOW PAID-OTR  (HD-E)"
   V18110 = "B19 PAY/HR-OTR OT  (H-E)"
   V18111 = "B20 GET NEW JOB?  (HD-E)"
   V18112 = "B21 DONE NOTHING   (H-E)"
   V18113 = "B21 PUBLIC EMP AGCY(H-E)"
   V18114 = "B21 PRIVATE EMP AGY(H-E)"
   V18115 = "B21 CURR EMP DIRECT(H-E)"
   V18116 = "B21 OTR EMPR DIRECT(H-E)"
   V18117 = "B21 FRIEND OR REL  (H-E)"
   V18118 = "B21 PLACE OR ANS AD(H-E)"
   V18119 = "B21 OTHER          (H-E)"
   V18120 = "B23 #MO PRESENT EMP(H-E)"
   V18121 = "B24 MO BEG PRES EMP(H-E)"
   V18122 = "B24 YR BEG PRES EMP(H-E)"
   V18123 = "B25 BEG WRK PRES POS H-E"
   V18124 = "B26 MO BEG PRES POS(H-E)"
   V18125 = "B26 YR BEG PRES POS(H-E)"
   V18126 = "B27 CHGE POS IN 89(HD-E)"
   V18127 = "B28 MO CHGE POS   (HD-E)"
   V18128 = "B29 TYPE OF CHGE  (HD-E)"
   V18129 = "B30 MO BEG PRES POS(H-E)"
   V18130 = "B30 YR BEG PRES POS(H-E)"
   V18131 = "B31 MO BEG PRES POS(H-E)"
   V18132 = "B31 YR BEG PRES POS(H-E)"
   V18133 = "B32 CHGE POS IN 89(HD-E)"
   V18134 = "B33 MO CHGE POS   (HD-E)"
   V18135 = "B34 TYPE OF CHGE  (HD-E)"
   V18136 = "B35-6 BEG OCC PRES EMP-H"
   V18137 = "B37 STARTING WAGE  (H-E)"
   V18138 = "B38 STARTING HR/WK (H-E)"
   V18139 = "B39 PRES EMP JAN89 (H-E)"
   V18140 = "B39 PRES EMP FEB89 (H-E)"
   V18141 = "B39 PRES EMP MAR89 (H-E)"
   V18142 = "B39 PRES EMP APR89 (H-E)"
   V18143 = "B39 PRES EMP MAY89 (H-E)"
   V18144 = "B39 PRES EMP JUN89 (H-E)"
   V18145 = "B39 PRES EMP JUL89 (H-E)"
   V18146 = "B39 PRES EMP AUG89 (H-E)"
   V18147 = "B39 PRES EMP SEP89 (H-E)"
   V18148 = "B39 PRES EMP OCT89 (H-E)"
   V18149 = "B39 PRES EMP NOV89 (H-E)"
   V18150 = "B39 PRES EMP DEC89 (H-E)"
   V18151 = "B40 OTR EMP 1989  (HD-E)"
   V18152 = "B41 MO BEG OTR POS(HD-E)"
   V18153 = "B41 YR BEG OTR POS(HD-E)"
   V18154 = "B42 OTR EMP JAN89  (H-E)"
   V18155 = "B42 OTR EMP FEB89  (H-E)"
   V18156 = "B42 OTR EMP MAR89  (H-E)"
   V18157 = "B42 OTR EMP APR89  (H-E)"
   V18158 = "B42 OTR EMP MAY89  (H-E)"
   V18159 = "B42 OTR EMP JUN89  (H-E)"
   V18160 = "B42 OTR EMP JUL89  (H-E)"
   V18161 = "B42 OTR EMP AUG89  (H-E)"
   V18162 = "B42 OTR EMP SEP89  (H-E)"
   V18163 = "B42 OTR EMP OCT89  (H-E)"
   V18164 = "B42 OTR EMP NOV89  (H-E)"
   V18165 = "B42 OTR EMP DEC89  (H-E)"
   V18166 = "B43 WORK SELF/OTR?(HD-E)"
   V18167 = "B44 CORP/UNCORP BUS(H-E)"
   V18168 = "B45 WRK GOV-OTR EMP? W-E"
   V18169 = "B46-47 OCC OTR EMP (H-E)"
   V18170 = "B48 IND OTR EMP    (H-E)"
   V18171 = "B49 START WAGE OTR EMP-H"
   V18172 = "B50 BEG HR/WK OTR EMP-HD"
   V18173 = "B51 CHG POS OTR EMP(H-E)"
   V18174 = "B52 MO CHGE POS   (HD-E)"
   V18175 = "B53 TYPE CHG OTR EMP H-E"
   V18176 = "B54 STOP WRK OTR EMP H-E"
   V18177 = "B55 MO END OTR EMP(HD-E)"
   V18178 = "B55 YR END OTR EMP(HD-E)"
   V18179 = "B56 WHY LEFT OTR EMP H-E"
   V18180 = "B57 END WAGE OTR EMP H-E"
   V18181 = "B58 END HR/WK OTR EM H-E"
   V18182 = "B59 ANY OTR EMP 89 (H-E)"
   V18183 = "B-# WRK HIST SUPPS (H-E)"
   V18184 = "B60 WTR OTRS ILL  (HD-E)"
   V18185 = "B61 # WKS OTR ILL (HD-E)"
   V18186 = "B63 WTR SELF ILL  (HD-E)"
   V18187 = "B64 # WKS SELF ILL(HD-E)"
   V18188 = "B66 WTR VACATION  (HD-E)"
   V18189 = "B67 # WK VACATION (HD-E)"
   V18190 = "B69 WTR STRIKE    (HD-E)"
   V18191 = "B70 # WK ON STRIKE (H-E)"
   V18192 = "B72 WTR UNEMPLOYED(HD-E)"
   V18193 = "B73 # WK UNEMPLOYED(H-E)"
   V18194 = "B75 WTR OUT LAB FRC(H-E)"
   V18195 = "B76 #WK OUT LAB FRC(H-E)"
   V18196 = "B78 # WKS WORKED  (HD-E)"
   V18197 = "B79 # HR/WK WORKED (H-E)"
   V18198 = "B80 WTR WORKED OT (HD-E)"
   V18199 = "B82 WTR XTRA JOBS (HD-E)"
   V18200 = "B94-106 # XTRA JOBS(H-E)"
   V18201 = "B83 WORK FOR GOVT?(HD-E)"
   V18202 = "B84-85 OCC-XTRA JOB1 H-E"
   V18203 = "B86 IND XTRA JOB1  (H-E)"
   V18204 = "B87 PAY/HR XTRA JB1(H-E)"
   V18205 = "B88 # WKS XTRA JOB1(H-E)"
   V18206 = "B89 HR/WK XTRA JOB1(H-E)"
   V18207 = "B90 MO BEG XJOB1   (H-E)"
   V18208 = "B90 YR BEG XJOB1   (H-E)"
   V18209 = "B91 WRK XJB1 JAN89 (H-E)"
   V18210 = "B91 WRK XJB1 FEB89 (H-E)"
   V18211 = "B91 WRK XJB1 MAR89 (H-E)"
   V18212 = "B91 WRK XJB1 APR89 (H-E)"
   V18213 = "B91 WRK XJB1 MAY89 (H-E)"
   V18214 = "B91 WRK XJB1 JUN89 (H-E)"
   V18215 = "B91 WRK XJB1 JUL89 (H-E)"
   V18216 = "B91 WRK XJB1 AUG89 (H-E)"
   V18217 = "B91 WRK XJB1 SEP89 (H-E)"
   V18218 = "B91 WRK XJB1 OCT89 (H-E)"
   V18219 = "B91 WRK XJB1 NOV89 (H-E)"
   V18220 = "B91 WRK XJB1 DEC89 (H-E)"
   V18221 = "B92 STOP WRK XJOB1 (H-E)"
   V18222 = "B93 MO END XJOB1  (HD-E)"
   V18223 = "B93 YR END XJOB1  (HD-E)"
   V18224 = "B95 WRK FOR GOV XJB2 H-E"
   V18225 = "B95-97 OCC-XTRA JOB2 H-E"
   V18226 = "B98 IND XTRA JOB2  (H-E)"
   V18227 = "B99 AV PY/HR X JB2+(H-E)"
   V18228 = "B100 #WKS XTRA JB2+(H-E)"
   V18229 = "B101 AV HR/WK X JB2+ H-E"
   V18230 = "B102 MO BEG XJOB2  (H-E)"
   V18231 = "B102 YR BEG XJOB2  (H-E)"
   V18232 = "B103 WRK XJOB2 JAN89 H-E"
   V18233 = "B103 WRK XJOB2 FEB89 H-E"
   V18234 = "B103 WRK XJOB2 MAR89 H-E"
   V18235 = "B103 WRK XJOB2 APR89 H-E"
   V18236 = "B103 WRK XJOB2 MAY89 H-E"
   V18237 = "B103 WRK XJOB2 JUN89 H-E"
   V18238 = "B103 WRK XJOB2 JUL89 H-E"
   V18239 = "B103 WRK XJOB2 AUG89 H-E"
   V18240 = "B103 WRK XJOB2 SEP89 H-E"
   V18241 = "B103 WRK XJOB2 OCT89 H-E"
   V18242 = "B103 WRK XJOB2 NOV89 H-E"
   V18243 = "B103 WRK XJOB2 DEC89 H-E"
   V18244 = "B104 STOP WRK XJOB2  H-E"
   V18245 = "B105 MO END XJOB2 (HD-E)"
   V18246 = "B105 YR END XJOB2 (HD-E)"
   V18247 = "C1 WTR LOOK FOR JOB(H-U)"
   V18248 = "C2 DONE NOTHING   (HD-U)"
   V18249 = "C2 PUBLIC EMP AGCY (H-U)"
   V18250 = "C2 PRIVATE EMP AGY (H-U)"
   V18251 = "C2 PREV EMP DIRECT (H-U)"
   V18252 = "C2 OTR EMPR DIRECT (H-U)"
   V18253 = "C2 FRIEND OR REL   (H-U)"
   V18254 = "C2 PLACE OR ANS AD (H-U)"
   V18255 = "C2 OTHER           (H-U)"
   V18256 = "C3 HOW LONG LOOK WRK H-U"
   V18257 = "C4 EVER WORKED?   (HD-U)"
   V18258 = "C5 MO LAST WORKED (HD-U)"
   V18259 = "C5 YR LAST WORKED (HD-U)"
   V18260 = "C6 WTR UNEMP 89    (H-U)"
   V18261 = "C7 # WK UNEMP 89   (H-U)"
   V18262 = "C9-10 OCC-LAST JOB (H-U)"
   V18263 = "C11 IND-LAST JOB  (HD-U)"
   V18264 = "C12 WRK SELF/OTR? (HD-U)"
   V18265 = "C13 CORP/UNCORP BUS(H-U)"
   V18266 = "C14 WORK FOR GOVT? (H-U)"
   V18267 = "C15 WHY LAST JOB END H-U"
   V18268 = "C16 MO BEG LAST EMP(H-U)"
   V18269 = "C16 YR BEG LAST EMP(H-U)"
   V18270 = "C17 BEG WK LAST POS(H-U)"
   V18271 = "C18 MO BEG LAST POS(H-U)"
   V18272 = "C18 YR BEG LAST POS(H-U)"
   V18273 = "C19 CHGE POS IN 89(HD-U)"
   V18274 = "C20 MO CHGE POS   (HD-U)"
   V18275 = "C21 TYPE OF CHGE  (HD-U)"
   V18276 = "C22 MO BEG LAST POS(H-U)"
   V18277 = "C22 YR BEG LAST POS(H-U)"
   V18278 = "C23 MO BEG LAST POS(H-U)"
   V18279 = "C23 YR BEG LAST POS(H-U)"
   V18280 = "C24 CHGE POS IN 89(HD-U)"
   V18281 = "C25 MO CHGE POS   (HD-U)"
   V18282 = "C26 TYPE OF CHGE  (HD-U)"
   V18283 = "C27-8 BEG OCC LAST EMP-H"
   V18284 = "C29 WAGE BEG LAST EMP-HD"
   V18285 = "C30 HR/WK BEG LAST EMP-H"
   V18286 = "C31 LAST EMP JAN89 (H-U)"
   V18287 = "C31 LAST EMP FEB89 (H-U)"
   V18288 = "C31 LAST EMP MAR89 (H-U)"
   V18289 = "C31 LAST EMP APR89 (H-U)"
   V18290 = "C31 LAST EMP MAY89 (H-U)"
   V18291 = "C31 LAST EMP JUN89 (H-U)"
   V18292 = "C31 LAST EMP JUL89 (H-U)"
   V18293 = "C31 LAST EMP AUG89 (H-U)"
   V18294 = "C31 LAST EMP SEP89 (H-U)"
   V18295 = "C31 LAST EMP OCT89 (H-U)"
   V18296 = "C31 LAST EMP NOV89 (H-U)"
   V18297 = "C31 LAST EMP DEC89 (H-U)"
   V18298 = "C32 OTR EMP 1989  (HD-U)"
   V18299 = "C33 MO BEG OTR EMP(HD-U)"
   V18300 = "C33 YR BEG OTR EMP(HD-U)"
   V18301 = "C34 OTR EMP JAN89  (H-U)"
   V18302 = "C34 OTR EMP FEB89  (H-U)"
   V18303 = "C34 OTR EMP MAR89  (H-U)"
   V18304 = "C34 OTR EMP APR89  (H-U)"
   V18305 = "C34 OTR EMP MAY89  (H-U)"
   V18306 = "C34 OTR EMP JUN89  (H-U)"
   V18307 = "C34 OTR EMP JUL89  (H-U)"
   V18308 = "C34 OTR EMP AUG89  (H-U)"
   V18309 = "C34 OTR EMP SEP89  (H-U)"
   V18310 = "C34 OTR EMP OCT89  (H-U)"
   V18311 = "C34 OTR EMP NOV89  (H-U)"
   V18312 = "C34 OTR EMP DEC89  (H-U)"
   V18313 = "C35 WORK SELF/OTR?(HD-U)"
   V18314 = "C36 CORP/UNCORP BUS(H-U)"
   V18315 = "C37 WRK GOV-OTR EMP? H-U"
   V18316 = "C38-39 OCC OTR EMP (H-U)"
   V18317 = "C40 IND OTR EMP   (HD-U)"
   V18318 = "C41 START WAGE OTR EMP-H"
   V18319 = "C42 BEG HR/WK OTR EMP-HD"
   V18320 = "C43 CHG POS OTR EMP(H-U)"
   V18321 = "C44 MO CHGE POS   (HD-U)"
   V18322 = "C45 TYPE CHG OTR EMP H-U"
   V18323 = "C46 STOP WRK OTR EMP H-U"
   V18324 = "C47 MO END OTR EMP(HD-U)"
   V18325 = "C47 YR END OTR EMP(HD-U)"
   V18326 = "C48 WHY LEFT OTR EMP H-U"
   V18327 = "C49 END WAGE OTR EMP H-U"
   V18328 = "C50 END HRS/WK OTR EMP-H"
   V18329 = "C51 ANY OTR EMP 89 (H-U)"
   V18330 = "C-# WORK HIST SUPPS(H-U)"
   V18331 = "C52 WTR VACATION  (HD-U)"
   V18332 = "C53 #WKS VACATION (HD-U)"
   V18333 = "C55 WTR OTRS ILL  (HD-U)"
   V18334 = "C56 #WKS OTRS ILL (HD-U)"
   V18335 = "C58 WTR SELF ILL  (HD-U)"
   V18336 = "C59 #WKS SELF ILL (HD-U)"
   V18337 = "C61 WTR ON STRIKE (HD-U)"
   V18338 = "C62 #WKS ON STRIKE (H-U)"
   V18339 = "C64 WTR UNEMPLOYED (H-U)"
   V18340 = "C65 #WK UNEMPLOYED (H-U)"
   V18341 = "C67 WTR OUT LAB FRC(H-U)"
   V18342 = "C68 #WKS OUT LAB FRC H-U"
   V18343 = "C70 # WKS WORKED  (HD-U)"
   V18344 = "C71 HR/WK WORKED  (HD-U)"
   V18345 = "C72 WTR WORKED OT (HD-U)"
   V18346 = "C74 WTR XTRA JOBS (HD-U)"
   V18347 = "C74-98 # XTRA JOBS (H-U)"
   V18348 = "C75 WORK FOR GOVT?(HD-U)"
   V18349 = "C76-77 OCC-XTRA JOB1 H-U"
   V18350 = "C78 IND XTRA JOB1 (HD-U)"
   V18351 = "C79 PAY/HR XTRA JOB1 H-U"
   V18352 = "C80 # WKS EXTRA JOB1 H-U"
   V18353 = "C81 HR/WK XTRA JOB1(H-U)"
   V18354 = "C82 MO BEG XTRA JOB1 H-U"
   V18355 = "C82 YR BEG XTRA JOB1 H-U"
   V18356 = "C83 WRK XJOB1 JAN89  H-U"
   V18357 = "C83 WRK XJOB1 FEB89  H-U"
   V18358 = "C83 WRK XJOB1 MAR89  H-U"
   V18359 = "C83 WRK XJOB1 APR89  H-U"
   V18360 = "C83 WRK XJOB1 MAY89  H-U"
   V18361 = "C83 WRK XJOB1 JUN89  H-U"
   V18362 = "C83 WRK XJOB1 JUL89  H-U"
   V18363 = "C83 WRK XJOB1 AUG89  H-U"
   V18364 = "C83 WRK XJOB1 SEP89  H-U"
   V18365 = "C83 WRK XJOB1 OCT89  H-U"
   V18366 = "C83 WRK XJOB1 NOV89  H-U"
   V18367 = "C83 WRK XJOB1 DEC89  H-U"
   V18368 = "C84 STOP WORK XJOB1  H-U"
   V18369 = "C85 MO END XJOB1  (HD-U)"
   V18370 = "C85 YR END XJOB1  (HD-U)"
   V18371 = "C87 WRK FOR GOV XJB2 H-U"
   V18372 = "C88-89 OCC-XTRA JB2(H-U)"
   V18373 = "C90 IND XTRA JOB2  (H-U)"
   V18374 = "C91 AV PY/HR X JB2+(H-U)"
   V18375 = "C92 # WK XTRA JOB2+(H-U)"
   V18376 = "C93 AV HR/WK X JB2+(H-U)"
   V18377 = "C94 MO BEG XJOB2   (H-U)"
   V18378 = "C94 YR BEG XJOB2   (H-U)"
   V18379 = "C95 WRK XJOB2 JAN89  H-U"
   V18380 = "C95 WRK XJOB2 FEB89  H-U"
   V18381 = "C95 WRK XJOB2 MAR89  H-U"
   V18382 = "C95 WRK XJOB2 APR89  H-U"
   V18383 = "C95 WRK XJOB2 MAY89  H-U"
   V18384 = "C95 WRK XJOB2 JUN89  H-U"
   V18385 = "C95 WRK XJOB2 JUL89  H-U"
   V18386 = "C95 WRK XJOB2 AUG89  H-U"
   V18387 = "C95 WRK XJOB2 SEP89  H-U"
   V18388 = "C95 WRK XJOB2 OCT89  H-U"
   V18389 = "C95 WRK XJOB2 NOV89  H-U"
   V18390 = "C95 WRK XJOB2 DEC89  H-U"
   V18391 = "C96 STOP WORK XJOB2  H-U"
   V18392 = "C97 MO END JOB2   (HD-U)"
   V18393 = "C97 YR END JOB2   (HD-U)"
   V18394 = "D1 CHKPT"
   V18395 = "D1A EMPLOYMENT STATUS-WF"
   V18396 = "D2 YEAR RETIRED   (WF-R)"
   V18397 = "D3 WORK FOR MONEY?(WF-E)"
   V18398 = "D4 WORK SELF/OTR? (WF-E)"
   V18399 = "D5 CORP/UNCORP BUS(WF-E)"
   V18400 = "D6 WORK FOR GOVT? (WF-E)"
   V18401 = "D7 JOB NOW UNION?  (W-E)"
   V18402 = "D8 BELONG UNION?  (WF-E)"
   V18403 = "D9-10 MAIN OCC:3 DIG W-E"
   V18404 = "D11 MAIN IND:3 DIGT(W-E)"
   V18405 = "D12 SLRY/HRLY/OTR  (W-E)"
   V18406 = "D13 PAY/HR-SALARY (WF-E)"
   V18407 = "D14 WTR SAL PD OT (WF-E)"
   V18408 = "D15 PAY/HR-SLRYOT (WF-E)"
   V18409 = "D16 PAY/HR-HOURLY (WF-E)"
   V18410 = "D17 PAY/HR-HRLY OT (W-E)"
   V18411 = "D18 HOW PAID-OTR  (WF-E)"
   V18412 = "D19 PAY/HR-OTR OT  (W-E)"
   V18413 = "D20 GET NEW JOB?  (WF-E)"
   V18414 = "D21 DONE NOTHING   (W-E)"
   V18415 = "D21 PUBLIC EMP AGCY(W-E)"
   V18416 = "D21 PRIVATE EMP AGY(W-E)"
   V18417 = "D21 CURR EMP DIRECT(W-E)"
   V18418 = "D21 OTR EMPR DIRECT(W-E)"
   V18419 = "D21 FRIEND OR REL  (W-E)"
   V18420 = "D21 PLACE OR ANS AD(W-E)"
   V18421 = "D21 OTHER          (W-E)"
   V18422 = "D23 #MO PRESENT EMP(W-E)"
   V18423 = "D24 MO BEG PRES EMP(W-E)"
   V18424 = "D24 YR BEG PRES EMP(W-E)"
   V18425 = "D25 BEG WRK PRES POS W-E"
   V18426 = "D26 MO BEG PRES POS(W-E)"
   V18427 = "D26 YR BEG PRES POS(W-E)"
   V18428 = "D27 CHGE POS IN 89(WF-E)"
   V18429 = "D28 MO CHGE POS   (WF-E)"
   V18430 = "D29 TYPE OF CHGE  (WF-E)"
   V18431 = "D30 MO BEG PRES POS(W-E)"
   V18432 = "D30 YR BEG PRES POS(W-E)"
   V18433 = "D31 MO BEG PRES POS(W-E)"
   V18434 = "D31 YR BEG PRES POS(W-E)"
   V18435 = "D32 CHGE POS IN 89(WF-E)"
   V18436 = "D33 MO CHGE POS   (WF-E)"
   V18437 = "D34 TYPE OF CHGE  (WF-E)"
   V18438 = "D35-6 BEG OCC PRES EMP-W"
   V18439 = "D37 STARTING WAGE  (W-E)"
   V18440 = "D38 STARTING HR/WK (W-E)"
   V18441 = "D39 PRES EMP JAN89 (W-E)"
   V18442 = "D39 PRES EMP FEB89 (W-E)"
   V18443 = "D39 PRES EMP MAR89 (W-E)"
   V18444 = "D39 PRES EMP APR89 (W-E)"
   V18445 = "D39 PRES EMP MAY89 (W-E)"
   V18446 = "D39 PRES EMP JUN89 (W-E)"
   V18447 = "D39 PRES EMP JUL89 (W-E)"
   V18448 = "D39 PRES EMP AUG89 (W-E)"
   V18449 = "D39 PRES EMP SEP89 (W-E)"
   V18450 = "D39 PRES EMP OCT89 (W-E)"
   V18451 = "D39 PRES EMP NOV89 (W-E)"
   V18452 = "D39 PRES EMP DEC89 (W-E)"
   V18453 = "D40 OTR EMP 1989  (WF-E)"
   V18454 = "D41 MO BEG OTR EMP(WF-E)"
   V18455 = "D41 YR BEG OTR EMP(WF-E)"
   V18456 = "D42 OTR EMP JAN89  (W-E)"
   V18457 = "D42 OTR EMP FEB89  (W-E)"
   V18458 = "D42 OTR EMP MAR89  (W-E)"
   V18459 = "D42 OTR EMP APR89  (W-E)"
   V18460 = "D42 OTR EMP MAY89  (W-E)"
   V18461 = "D42 OTR EMP JUN89  (W-E)"
   V18462 = "D42 OTR EMP JUL89  (W-E)"
   V18463 = "D42 OTR EMP AUG89  (W-E)"
   V18464 = "D42 OTR EMP SEP89  (W-E)"
   V18465 = "D42 OTR EMP OCT89  (W-E)"
   V18466 = "D42 OTR EMP NOV89  (W-E)"
   V18467 = "D42 OTR EMP DEC89  (W-E)"
   V18468 = "D43 WORK SELF/OTR?(WF-E)"
   V18469 = "D44 CORP/UNCORP BUS(W-E)"
   V18470 = "D45 WRK GOV-OTR EMP? W-E"
   V18471 = "D46-47 OCC OTR EMP (W-E)"
   V18472 = "D48 IND OTR EMP    (W-E)"
   V18473 = "D49 START WAGE OTR EMP-W"
   V18474 = "D50 BEG HR/WK OTR EMP-WF"
   V18475 = "D51 CHG POS OTR EMP(W-E)"
   V18476 = "D52 MO CHGE POS   (WF-E)"
   V18477 = "D53 TYPE CHG OTR EMP W-E"
   V18478 = "D54 STOP WRK OTR EMP W-E"
   V18479 = "D55 MO END OTR EMP (W-E)"
   V18480 = "D55 YR END OTR EMP (W-E)"
   V18481 = "D56 WHY LEFT OTR EMP W-E"
   V18482 = "D57 END WAGE OTR EMP W-E"
   V18483 = "D58 END HR/WK OTR EMP-WF"
   V18484 = "D59 ANY OTR EMP 89 (W-E)"
   V18485 = "D-# WRK HIST SUPPS (W-E)"
   V18486 = "D60 WTR OTRS ILL  (WF-E)"
   V18487 = "D61 # WKS OTR ILL (WF-E)"
   V18488 = "D63 WTR SELF ILL  (WF-E)"
   V18489 = "D64 # WKS SELF ILL(WF-E)"
   V18490 = "D66 WTR VACATION  (WF-E)"
   V18491 = "D67 # WK VACATION (WF-E)"
   V18492 = "D69 WTR STRIKE    (WF-E)"
   V18493 = "D70 # WK ON STRIKE (W-E)"
   V18494 = "D72 WTR UNEMPLOYED(WF-E)"
   V18495 = "D73 # WK UNEMPLOYED(W-E)"
   V18496 = "D75 WTR OUT LAB FRC(W-E)"
   V18497 = "D76 #WK OUT LAB FRC(W-E)"
   V18498 = "D78 # WKS WORKED  (WF-E)"
   V18499 = "D79 # HR/WK WORKED (W-E)"
   V18500 = "D80 WTR WORKED OT (WF-E)"
   V18501 = "D82 WTR XTRA JOBS (WF-E)"
   V18502 = "D82-106 # XTRA JOBS(W-E)"
   V18503 = "D83 WORK FOR GOVT?(WF-E)"
   V18504 = "D84-85 OCC-XTRA JOB1 W-E"
   V18505 = "D86 IND XTRA JOB1  (W-E)"
   V18506 = "D87 PAY/HR XTRA JB1(W-E)"
   V18507 = "D88 # WKS XTRA JOB1(W-E)"
   V18508 = "D89 HR/WK XTRA JOB1(W-E)"
   V18509 = "D90 MO BEG XTRA JOB1 W-E"
   V18510 = "D90 YR BEG XTRA JOB1 W-E"
   V18511 = "D91 WRK XJB1 JAN89 (W-E)"
   V18512 = "D91 WRK XJB1 FEB89 (W-E)"
   V18513 = "D91 WRK XJB1 MAR89 (W-E)"
   V18514 = "D91 WRK XJB1 APR89 (W-E)"
   V18515 = "D91 WRK XJB1 MAY89 (W-E)"
   V18516 = "D91 WRK XJB1 JUN89 (W-E)"
   V18517 = "D91 WRK XJB1 JUL89 (W-E)"
   V18518 = "D91 WRK XJB1 AUG89 (W-E)"
   V18519 = "D91 WRK XJB1 SEP89 (W-E)"
   V18520 = "D91 WRK XJB1 OCT89 (W-E)"
   V18521 = "D91 WRK XJB1 NOV89 (W-E)"
   V18522 = "D91 WRK XJB1 DEC89 (W-E)"
   V18523 = "D92 STOP WRK XJOB1 (W-E)"
   V18524 = "D93 MO END XJOB1  (WF-E)"
   V18525 = "D93 YR END XJOB1  (WF-E)"
   V18526 = "D95 WRK FOR GOV XJB2 W-E"
   V18527 = "D95-97 OCC-XTRA JOB2 W-E"
   V18528 = "D98 IND XTRA JOB2  (W-E)"
   V18529 = "D99 AV PY/HR X JB2+(W-E)"
   V18530 = "D100 #WKS XTRA JB2+(W-E)"
   V18531 = "D101 AV HR/WK X JB2+ W-E"
   V18532 = "D102 MO BEG XJOB2  (W-E)"
   V18533 = "D102 YR BEG XJOB2  (W-E)"
   V18534 = "D103 WRK XJOB2 JAN89 W-E"
   V18535 = "D103 WRK XJOB2 FEB89 W-E"
   V18536 = "D103 WRK XJOB2 MAR89 W-E"
   V18537 = "D103 WRK XJOB2 APR89 W-E"
   V18538 = "D103 WRK XJOB2 MAY89 W-E"
   V18539 = "D103 WRK XJOB2 JUN89 W-E"
   V18540 = "D103 WRK XJOB2 JUL89 W-E"
   V18541 = "D103 WRK XJOB2 AUG89 W-E"
   V18542 = "D103 WRK XJOB2 SEP89 W-E"
   V18543 = "D103 WRK XJOB2 OCT89 W-E"
   V18544 = "D103 WRK XJOB2 NOV89 W-E"
   V18545 = "D103 WRK XJOB2 DEC89 W-E"
   V18546 = "D104 STOP WORK XJOB2 W-E"
   V18547 = "D105 MO END XJOB2 (WF-E)"
   V18548 = "D105 YR END XJOB2 (WF-E)"
   V18549 = "E1 WTR LOOK FOR JOB(W-U)"
   V18550 = "E2 DONE NOTHING   (WF-U)"
   V18551 = "E2 PUBLIC EMP AGCY (W-U)"
   V18552 = "E2 PRIVATE EMP AGY (W-U)"
   V18553 = "E2 PREV EMP DIRECT (W-U)"
   V18554 = "E2 OTR EMPR DIRECT (W-U)"
   V18555 = "E2 FRIEND OR REL   (W-U)"
   V18556 = "E2 PLACE OR ANS AD (W-U)"
   V18557 = "E2 OTHER           (W-U)"
   V18558 = "E3 HOW LONG LOOK WRK W-U"
   V18559 = "E4 EVER WORKED?   (WF-U)"
   V18560 = "E5 MO LAST WORKED (WF-U)"
   V18561 = "E5 YR LAST WORKED (WF-U)"
   V18562 = "E6 WTR UNEMP 89    (W-U)"
   V18563 = "E7 # WK UNEMP 89   (W-U)"
   V18564 = "E9-10 OCC-LAST JOB (W-U)"
   V18565 = "E11 IND-LAST JOB  (WF-U)"
   V18566 = "E12 WRK SELF/OTR? (WF-U)"
   V18567 = "E13 CORP/UNCORP BUS(W-U)"
   V18568 = "E14 WORK FOR GOVT? (W-U)"
   V18569 = "E15 WHY LAST JOB END W-U"
   V18570 = "E16 MO BEG LAST EMP(W-U)"
   V18571 = "E16 YR BEG LAST EMP(W-U)"
   V18572 = "E17 BEG WK LAST POS(W-U)"
   V18573 = "E18 MO BEG LAST POS(W-U)"
   V18574 = "E18 YR BEG LAST POS(W-U)"
   V18575 = "E19 CHGE POS IN 89(WF-U)"
   V18576 = "E20 MO CHGE POS   (WF-U)"
   V18577 = "E21 TYPE OF CHGE  (WF-U)"
   V18578 = "E22 MO BEG LAST POS(W-U)"
   V18579 = "E22 YR BEG LAST POS(W-U)"
   V18580 = "E23 MO BEG LAST POS(W-U)"
   V18581 = "E23 YR BEG LAST POS(W-U)"
   V18582 = "E24 CHGE POS IN 89(WF-U)"
   V18583 = "E25 MO CHGE POS   (WF-U)"
   V18584 = "E26 TYPE OF CHGE  (WF-U)"
   V18585 = "E27-8 BEG OCC LAST EMP-W"
   V18586 = "E29 BEG WAGE LAST EMP-WF"
   V18587 = "E30 HR/WK BEG LAST EMP-W"
   V18588 = "E31 LAST EMP JAN89 (W-U)"
   V18589 = "E31 LAST EMP FEB89 (W-U)"
   V18590 = "E31 LAST EMP MAR89 (W-U)"
   V18591 = "E31 LAST EMP APR89 (W-U)"
   V18592 = "E31 LAST EMP MAY89 (W-U)"
   V18593 = "E31 LAST EMP JUN89 (W-U)"
   V18594 = "E31 LAST EMP JUL89 (W-U)"
   V18595 = "E31 LAST EMP AUG89 (W-U)"
   V18596 = "E31 LAST EMP SEP89 (W-U)"
   V18597 = "E31 LAST EMP OCT89 (W-U)"
   V18598 = "E31 LAST EMP NOV89 (W-U)"
   V18599 = "E31 LAST EMP DEC89 (W-U)"
   V18600 = "E32 OTR EMP 1989  (WF-U)"
   V18601 = "E33 MO BEG OTR EMP(WF-U)"
   V18602 = "E33 YR BEG OTR EMP(WF-U)"
   V18603 = "E34 OTR EMP JAN89  (W-U)"
   V18604 = "E34 OTR EMP FEB89  (W-U)"
   V18605 = "E34 OTR EMP MAR89  (W-U)"
   V18606 = "E34 OTR EMP APR89  (W-U)"
   V18607 = "E34 OTR EMP MAY89  (W-U)"
   V18608 = "E34 OTR EMP JUN89  (W-U)"
   V18609 = "E34 OTR EMP JUL89  (W-U)"
   V18610 = "E34 OTR EMP AUG89  (W-U)"
   V18611 = "E34 OTR EMP SEP89  (W-U)"
   V18612 = "E34 OTR EMP OCT89  (W-U)"
   V18613 = "E34 OTR EMP NOV89  (W-U)"
   V18614 = "E34 OTR EMP DEC89  (W-U)"
   V18615 = "E35 WORK SELF/OTR?(WF-U)"
   V18616 = "E36 CORP/UNCORP BUS(W-U)"
   V18617 = "E37 WRK GOV-OTR EMP? W-U"
   V18618 = "E38-39 OCC OTR EMP (W-U)"
   V18619 = "E40 IND OTR EMP   (WF-U)"
   V18620 = "E41 START WAGE OTR EMP-W"
   V18621 = "E42 BEG HR/WK OTR EMP-WF"
   V18622 = "E43 CHG POS OTR EMP(W-U)"
   V18623 = "E44 MO CHGE POS   (WF-U)"
   V18624 = "E45 TYPE CHG OTR EMP W-U"
   V18625 = "E46 STOP WRK OTR EMP W-U"
   V18626 = "E47 MO END OTR EMP(WF-U)"
   V18627 = "E47 YR END OTR EMP(WF-U)"
   V18628 = "E48 WHY LEFT OTR EMP W-U"
   V18629 = "E49 END WAGE OTR EMP W-U"
   V18630 = "E50 END HR/WK OTR EMP-WF"
   V18631 = "E51 ANY OTR EMP 89 (W-U)"
   V18632 = "E-# WORK HIST SUPPS(W-U)"
   V18633 = "E52 WTR VACATION  (WF-U)"
   V18634 = "E53 #WKS VACATION (WF-U)"
   V18635 = "E55 WTR OTRS ILL  (WF-U)"
   V18636 = "E56 #WKS OTRS ILL (WF-U)"
   V18637 = "E58 WTR SELF ILL  (WF-U)"
   V18638 = "E59 #WKS SELF ILL (WF-U)"
   V18639 = "E61 WTR ON STRIKE (WF-U)"
   V18640 = "E62 #WKS ON STRIKE (W-U)"
   V18641 = "E64 WTR UNEMPLOYED (W-U)"
   V18642 = "E65 #WK UNEMPLOYED (W-U)"
   V18643 = "E67 WTR OUT LAB FRC(W-U)"
   V18644 = "E68 #WKS OUT LAB FRC W-U"
   V18645 = "E70 # WKS WORKED  (WF-U)"
   V18646 = "E71 HR/WK WORKED  (WF-U)"
   V18647 = "E72 WTR WORKED OT (WF-U)"
   V18648 = "E74 WTR XTRA JOBS (WF-U)"
   V18649 = "E74-98 # XTRA JOBS (W-U)"
   V18650 = "E75 WORK FOR GOVT?(WF-U)"
   V18651 = "E76-77 OCC-XTRA JOB1 W-U"
   V18652 = "E78 IND XTRA JOB1 (WF-U)"
   V18653 = "E79 PAY/HR XTRA JOB1 W-U"
   V18654 = "E80 # WKS EXTRA JOB1 W-U"
   V18655 = "E81 HR/WK XTRA JOB1(W-U)"
   V18656 = "E82 MO BEG XTRA JOB1 W-U"
   V18657 = "E82 YR BEG XTRA JOB1 W-U"
   V18658 = "E83 WRK XJOB1 JAN89  W-U"
   V18659 = "E83 WRK XJOB1 FEB89  W-U"
   V18660 = "E83 WRK XJOB1 MAR89  W-U"
   V18661 = "E83 WRK XJOB1 APR89  W-U"
   V18662 = "E83 WRK XJOB1 MAY89  W-U"
   V18663 = "E83 WRK XJOB1 JUN89  W-U"
   V18664 = "E83 WRK XJOB1 JUL89  W-U"
   V18665 = "E83 WRK XJOB1 AUG89  W-U"
   V18666 = "E83 WRK XJOB1 SEP89  W-U"
   V18667 = "E83 WRK XJOB1 OCT89  W-U"
   V18668 = "E83 WRK XJOB1 NOV89  W-U"
   V18669 = "E83 WRK XJOB1 DEC89  W-U"
   V18670 = "E84 STOP WORK XJOB1  W-U"
   V18671 = "E85 MO END XJOB1  (WF-U)"
   V18672 = "E85 YR END XJOB1  (WF-U)"
   V18673 = "E87 WRK FOR GOV XJB2 W-U"
   V18674 = "E88-89 OCC-XTRA JB2(W-U)"
   V18675 = "E90 IND XTRA JOB2  (W-U)"
   V18676 = "E91 AV PY/HR X JB2+(W-U)"
   V18677 = "E92 # WK XTRA JOB2+(W-U)"
   V18678 = "E93 AV HR/WK X JB2+(W-U)"
   V18679 = "E94 MO BEG XJOB2   (W-U)"
   V18680 = "E94 YR BEG XJOB2   (W-U)"
   V18681 = "E95 WRK XJOB2 JAN89  W-U"
   V18682 = "E95 WRK XJOB2 FEB89  W-U"
   V18683 = "E95 WRK XJOB2 MAR89  W-U"
   V18684 = "E95 WRK XJOB2 APR89  W-U"
   V18685 = "E95 WRK XJOB2 MAY89  W-U"
   V18686 = "E95 WRK XJOB2 JUN89  W-U"
   V18687 = "E95 WRK XJOB2 JUL89  W-U"
   V18688 = "E95 WRK XJOB2 AUG89  W-U"
   V18689 = "E95 WRK XJOB2 SEP89  W-U"
   V18690 = "E95 WRK XJOB2 OCT89  W-U"
   V18691 = "E95 WRK XJOB2 NOV89  W-U"
   V18692 = "E95 WRK XJOB2 DEC89  W-U"
   V18693 = "E96 STOP WORK XJOB2  W-U"
   V18694 = "E97 MO END JOB2   (WF-U)"
   V18695 = "E97 YR END JOB2   (WF-U)"
   V18696 = "F1 CKPT:TYPE HEAD+WIFE"
   V18697 = "F2 HOUSEWORK HRS-WIFE"
   V18698 = "F3 HOUSEWORK HOURS-HEAD"
   V18699 = "F5 FAM TOGETHR MAIN MEAL"
   V18700 = "F7 COST CHILD CARE 1989"
   V18701 = "G2 WHETHER HEAD FARMER"
   V18702 = "G3 TOTAL FARM RECEIPTS"
   V18703 = "G6 WHETHER BUSINESS"
   V18704 = "G7 TYPE BUS HAVE INT IN"
   V18705 = "G8 WHO IN FAM OWNED BUS"
   V18706 = "G9 R PUT TIME IN BUS 89?"
   V18707 = "G10 CORP/UNINCORP BUS"
   V18708 = "G99 WTR LUMP SUM PAYMNTS"
   V18709 = "G100 LUMP SUM PAYMNTS"
   V18710 = "G101 INHERITANCE"
   V18711 = "G102 WTR ITEM 89 TAX DED"
   V18712 = "G103 WTR HELP SUPPORT OT"
   V18713 = "G104 # OTRS SUPPORTED"
   V18714 = "G105 WHO SUPPORTED 1"
   V18715 = "G105 WHO SUPPORTED 2"
   V18716 = "G105 WHO SUPPORTED 3"
   V18717 = "G107 ANY CHILD SUPPORT"
   V18718 = "G109 ANY ALIMONY"
   V18719 = "G112-4 WTR DEPENDNT OTRS"
   V18720 = "G113 # OTR DEPENDENTS"
   V18721 = "H1 STATUS OF HEALTH-HEAD"
   V18722 = "H2 LIMIT TYPE/AMT WRK  H"
   V18723 = "H3 NOT DO CERTAIN WRK  H"
   V18724 = "H4 LIMIT AMT WRK DO    H"
   V18725 = "H5 ANY REC MED AID? 89"
   V18726 = "H7 IWCKPT-W/'W' IN FU?"
   V18727 = "H8 STATUS OF HLTH-WIFE"
   V18728 = "H9 LIMIT TYPE/AMT WRK W"
   V18729 = "H10 NOT DO CERTAIN WRK W"
   V18730 = "H11 LIMIT AMT WORK DO  W"
   V18731 = "H12 IWCKPT:OTHER IN FU"
   V18732 = "H13 HEALTH STATUS OFUM"
   V18733 = "L1 CKPT: WTR WIFE"
   V18734 = "L2-3 EDUC OF FATHER   WF"
   V18735 = "L4-5 EDUC OF MOTHER   WF"
   V18736 = "L6 WHETHER BROTHERS   WF"
   V18737 = "L7 # BROTHERS       WIFE"
   V18738 = "L8 ONLY BRO STILL ALIVE"
   V18739 = "L9 ONLY BRO OLDR THAN W"
   V18740 = "L10 # BRO STILL ALIVE"
   V18741 = "L11 ANY BRO OLDR THAN WF"
   V18742 = "L12 WHETHER SISTERS   WF"
   V18743 = "L13 # SISTERS       WIFE"
   V18744 = "L14 ONLY SIS STILL ALIVE"
   V18745 = "L15 ONLY SIS OLDR THAN W"
   V18746 = "L16 # SIS STILL ALIVE"
   V18747 = "L17 ANY SIS OLDR THAN WF"
   V18748 = "L18 SPANISH DESCENT   WF"
   V18749 = "L19 RACE OF WIFE 1"
   V18750 = "L19 RACE OF WIFE 2"
   V18751 = "L20 WTR IN MILIT SERV  W"
   V18752 = "L21 WTR GRADUATED HS  WF"
   V18753 = "L22 YR GRADUATED HS   WF"
   V18754 = "L23 GRADE LEVEL IF GED W"
   V18755 = "L24 YR LAST IN SCH-GED W"
   V18756 = "L25 YR RECEIVED GED   WF"
   V18757 = "L26 GRD OF SCH FINISH  W"
   V18758 = "L27 YR LAST IN SCH-NONGR"
   V18759 = "L28 WTR ATTEND COLLEGE W"
   V18760 = "L29 YR LAST ATTEND COLL"
   V18761 = "L30 HGHST YR COLL COMP W"
   V18762 = "L31 WTR RECD COLL DEG  W"
   V18763 = "L32 HGHST COLL DEG REC W"
   V18764 = "L35 YR RECD COLL DEG   W"
   V18765 = "L36 WTR REC OTR DEG/CERT"
   V18766 = "L36 # OTR DEG/CERT REC"
   V18767 = "L37 TYPE OTR DEG/CERT 1"
   V18768 = "L38 FIELD OF DEG/CERT 1"
   V18769 = "L39 INST/ORG DEG/CERT 1"
   V18770 = "L40 YR REC DEG/CERT 1"
   V18771 = "L37 TYPE OTR DEG/CERT 2"
   V18772 = "L38 FIELD OF DEG/CERT 2"
   V18773 = "L39 INST/ORG DEG/CERT 2"
   V18774 = "L40 YR REC DEG/CERT 2"
   V18775 = "L37 TYPE OTR DEG/CERT 3"
   V18776 = "L38 FIELD OF DEG/CERT 3"
   V18777 = "L39 INST/ORG DEG/CERT 3"
   V18778 = "L40 YR REC DEG/CERT 3"
   V18779 = "L42-43 RELIGIOUS PREF  W"
   V18780 = "L44 #YR WRKD SINCE 18  W"
   V18781 = "L45 #YR WRKD FULL-TIME W"
   V18782 = "M1 CKPT: WTR NEW HEAD"
   V18783 = "M2 STATE FA GREW UP   HD"
   V18784 = "M2 CNTY FA GREW UP    HD"
   V18785 = "M3 STATE MO GREW UP   HD"
   V18786 = "M3 CNTY MO GREW UP    HD"
   V18787 = "M4 OCCUPATION OF FA   HD"
   V18788 = "M5 FIRST OCCUPATION   HD"
   V18789 = "M6 # DIFF JOBS OR?    HD"
   V18790 = "M7 GREW UP FARM OR?   HD"
   V18791 = "M8-9 STATE GREW UP    HD"
   V18792 = "M8-9 CNTY GREW UP     HD"
   V18793 = "M8-10 #REGIONS LIVED  HD"
   V18794 = "M8-10 #STATES LIVED   HD"
   V18795 = "M11 EVER MOVE FOR JOB? H"
   V18796 = "M12 NOT MOVED FOR JOB? H"
   V18797 = "M13 PARENTS POOR OR?  HD"
   V18798 = "M14-15 EDUC OF FATHER  H"
   V18799 = "M16-17 EDUC OF MOTHER  H"
   V18800 = "M18 WTR BROTHERS    HEAD"
   V18801 = "M19 # BROTHERS      HEAD"
   V18802 = "M20 ONLY BRO STILL ALIVE"
   V18803 = "M21 ONLY BRO OLDR THAN H"
   V18804 = "M22 # BRO STILL ALIVE"
   V18805 = "M23 ANY BRO OLDR THAN H"
   V18806 = "M24 WTR SISTERS      HEA"
   V18807 = "M25 # SISTERS       HEAD"
   V18808 = "M26 ONLY SIS STILL ALIVE"
   V18809 = "M27 ONLY SIS OLDR THAN H"
   V18810 = "M28 # SIS STILL ALIVE"
   V18811 = "M29 ANY SIS OLDR THAN H"
   V18812 = "M30 LIVE W BOTH PARENT H"
   V18813 = "M31 SPANISH DESCENT   HD"
   V18814 = "M32 RACE OF HEAD 1"
   V18815 = "M32 RACE OF HEAD 2"
   V18816 = "M33 WTR IN MILIT SERV  H"
   V18817 = "M34 WTR GRADUATED HS  HD"
   V18818 = "M35 MO GRADUATED HS   HD"
   V18819 = "M35 YR GRADUATED HS   HD"
   V18820 = "M36 GRADE LEVEL IF GED H"
   V18821 = "M37 MO LAST IN SCH-GED H"
   V18822 = "M37 YR LAST IN SCH-GED H"
   V18823 = "M38 MO RECEIVED GED   HD"
   V18824 = "M38 YR RECEIVED GED   HD"
   V18825 = "M39 GRD OF SCH FINISH  H"
   V18826 = "M40 MO LAST IN SCH-NONGR"
   V18827 = "M40 YR LAST IN SCH-NONGR"
   V18828 = "M41 WTR ATTEND COLLEGE H"
   V18829 = "M42 MO LAST ATTND COLL H"
   V18830 = "M42 YR LAST ATTND COLL H"
   V18831 = "M43 HGHST YR COLL COMP H"
   V18832 = "M44 WTR RECD COLL DEG  H"
   V18833 = "M45 HGHST COLL DEG REC H"
   V18834 = "M48 MO RECD COLL DEG  HD"
   V18835 = "M48 YR RECD COLL DEG  HD"
   V18836 = "M49 WTR REC OTR DEG/CERT"
   V18837 = "M49 # OTR DEG/CERT REC"
   V18838 = "M50 TYPE OTR DEG/CERT 1"
   V18839 = "M51 FIELD OF DEG/CERT 1"
   V18840 = "M52 INST/ORG DEG/CERT 1"
   V18841 = "M53 MO REC DEG/CERT 1"
   V18842 = "M53 YR REC DEG/CERT 1"
   V18843 = "M50 TYPE OTR DEG/CERT 2"
   V18844 = "M51 FIELD OF DEG/CERT 2"
   V18845 = "M52 INST/ORG DEG/CERT 2"
   V18846 = "M53 MO REC DEG/CERT 2"
   V18847 = "M53 YR REC DEG/CERT 2"
   V18848 = "M50 TYPE OTR DEG/CERT 3"
   V18849 = "M51 FIELD OF DEG/CERT 3"
   V18850 = "M52 INST/ORG DEG/CERT 3"
   V18851 = "M53 MO REC DEG/CERT 3"
   V18852 = "M53 YR REC DEG/CERT 3"
   V18853 = "M55-56 RELIGIOUS PREF  H"
   V18854 = "M57 #YR WRKD SINCE 18  H"
   V18855 = "M58 #YR WRKD FULL-TIME H"
   V18856 = "FS7 WHO WAS RESPONDENT"
   V18857 = "FS8 # OF INTERVWR CALLS"
   V18858 = "LANGUAGE OF IW ENGLISH?"
   V18859 = "LANGUAGE OF IW SPANISH?"
   V18860 = "LANGUAGE OF IW OTHER?"
   V18861 = "# OF INDIVIDUAL RECORDS"
   V18862 = "H+W 1989 FED TAXES"
   V18863 = "H+W 89 MARGINAL TAX RATE"
   V18864 = "1ST XTRA ERNER 89 TAXES"
   V18865 = "MARG TAX RATE ERNR ONE"
   V18866 = "2ND XTRA ERNER 89 TAXES"
   V18867 = "MARG TAX RATE ERNR TWO"
   V18868 = "3RD XTRA ERNER 89 TAXES"
   V18869 = "MARG TAX RATE ERNR THREE"
   V18870 = "4TH XTRA ERNER 89 TAXES"
   V18871 = "MARG TAX RATE ERNR FOUR"
   V18872 = "5TH XTRA ERNER 89 TAXES"
   V18873 = "MARG TAX RATE ERNR FIVE"
   V18874 = "TOT TAXES ALL XTRA ERNR"
   V18875 = "TOT FAM MONEY Y 89"
   V18876 = "P TOT FAM MNY Y 89 ACC>1"
   V18877 = "P TOT FAM MNY Y 89 ACC>0"
   V18878 = "TOTAL HEAD LABOR Y 89"
   V18879 = "P TOT HD LAB Y 89 ACC>1"
   V18880 = "P TOT HD LAB Y 89 ACC>0"
   V18881 = "WEEKLY FOOD NEEDS-1990"
   V18882 = "ANNUAL NEEDS STD-1989"
   V18883 = "1989 TOT FAM Y/NEEDS"
   V18884 = "ANNUAL NEEDS STD-CENSUS"
   V18885 = "TOT FAM Y/NEEDS-CENSUS"
   V18886 = "ANNUAL FOOD STD"
   V18887 = "HEAD 89 AVG HRLY EARNING"
   V18888 = "WIFE 89 AVG HRLY EARNING"
   V18889 = "REGION OF 1990 INTERVIEW"
   V18890 = "STATE CODE (FIPS)"
   V18891 = "COUNTY CODE (FIPS)"
   V18892 = "RURAL-URBAN CODE (BEALE)"
   V18893 = "REGION 90 HD GREW UP"
   V18894 = "HEAD GEOGRAPHIC MOBILITY"
   V18895 = "ACC 89 Y COMPONENTS"
   V18896 = "# MINOR ASSGMTS IN 90"
   V18897 = "# MAJOR ASSGMTS IN 90"
   V18898 = "EDUCATION 1990 HEAD"
   V18899 = "EDUCATION 1990 WIFE"
   V18900 = "DECILE: 89 TOT FAM Y"
   V18901 = "# CHILDREN AGE 1-2"
   V18902 = "# CHILDREN AGE 3-5"
   V18903 = "# CHILDREN AGE 6-13"
   V18904 = "# FEM CHILDREN AGE 14-17"
   V18905 = "# MALE CHILDREN 14-17"
   V18906 = "# FEM CHILDREN 18-20"
   V18907 = "# MALE CHILDREN 18-20"
   V18908 = "# FEM CHILDREN 21-29"
   V18909 = "# MALE CHILDREN 21-29"
   V18910 = "# INDS IN ARMED FORCES"
   V18911 = "# INDS INCARCERATED"
   V18912 = "# INDS IN HLTH CARE FACL"
   V18913 = "# INDS IN EDUCATNL FACIL"
   V18914 = "SPLIT SAMPLE FILTER"
   V18915 = "CNTY UNEMP RATE-CENSUS"
   V18916 = "MARITAL STATUS 1990"
   V18917 = "89-90 CNG MARITAL STATUS"
   V18918 = "COUPLE STATUS OF HEAD"
   V18919 = "YR NEW HEAD IN FU"
   V18920 = "YR NEW WIFE IN FU"
   V18921 = "HD-SPOUSE SAMPLE STATUS"
   V18922 = "# 90 S/O FROM THIS FAM"
   V18923 = "90 MAIN FAM ID FOR S/0"
   V18924 = "90ID OF 1ST OTR FU IN HU"
   V18925 = "REL OF 1ST OTHER FU"
   V18926 = "SIZE OF 1ST OTHER FU"
   V18927 = "90ID OF 2ND OTR FU IN HU"
   V18928 = "REL OF 2ND OTHER FU"
   V18929 = "SIZE OF 2ND OTHER FU"
   V18930 = "90ID OF 3RD OTR FU IN HU"
   V18931 = "REL OF 3RD OTHER FU"
   V18932 = "SIZE OF 3RD OTHER FU"
   V18933 = "90ID OF 4TH OTR FU IN HU"
   V18934 = "REL OF 4TH OTHER FU"
   V18935 = "SIZE OF 4TH OTHER FU"
   V18936 = "HOUSEHOLD ID #"
   V18937 = "# BORN TO HD ONLY IN 89"
   V18938 = "#BORN TO W/'W' ONLY IN89"
   V18939 = "#BRN TO H+W JOINTLY IN89"
   V18940 = "# BORN TO OFUMS IN 89"
   V18941 = "HEALTH QNAIRE FOR HEAD?"
   V18942 = "HEALTH QNAIRE FOR WIFE?"
   V18943 = "1990 CORE FAMILY WEIGHT"
   V18944 = "1990 LATINO FAM WEIGHT"
   V18945 = "1990 COMBINED FAM WEIGHT";

* USER-DEFINED MISSING VALUE RECODE TO SAS SYSMIS;

IF V17703=99 THEN V17703=.;
IF V17704=999 THEN V17704=.;
IF V17705=99999 THEN V17705=.;
IF V17706=9 THEN V17706=.;
IF V17708=9 THEN V17708=.;
IF V17709=9 THEN V17709=.;
IF V17717=9999 THEN V17717=.;
IF V17718=999 THEN V17718=.;
IF V17719=99 THEN V17719=.;
IF V17720=9 THEN V17720=.;
IF V17721=99 THEN V17721=.;
IF V17723=9 THEN V17723=.;
IF V17732=9999 THEN V17732=.;
IF V17737=9999 THEN V17737=.;
IF V17755=9 THEN V17755=.;
IF V17756=9 THEN V17756=.;
IF V17757=9 THEN V17757=.;
IF V17758=9 THEN V17758=.;
IF V17759=9 THEN V17759=.;
IF V17760=9 THEN V17760=.;
IF V17761=9 THEN V17761=.;
IF V17762=9 THEN V17762=.;
IF V17763=9 THEN V17763=.;
IF V17764=9 THEN V17764=.;
IF V17765=9 THEN V17765=.;
IF V17766=9 THEN V17766=.;
IF V17785=9 THEN V17785=.;
IF V17786=9 THEN V17786=.;
IF V17787=9 THEN V17787=.;
IF V17788=9 THEN V17788=.;
IF V17789=9 THEN V17789=.;
IF V17790=9 THEN V17790=.;
IF V17791=9 THEN V17791=.;
IF V17792=9 THEN V17792=.;
IF V17793=9 THEN V17793=.;
IF V17794=9 THEN V17794=.;
IF V17795=9 THEN V17795=.;
IF V17796=9 THEN V17796=.;
IF V17804=9 THEN V17804=.;
IF V17813=99 THEN V17813=.;
IF V17814=9 THEN V17814=.;
IF V17815=9 THEN V17815=.;
IF V17816=9 THEN V17816=.;
IF V17817=9 THEN V17817=.;
IF V17818=9 THEN V17818=.;
IF V17819=9 THEN V17819=.;
IF V17820=9 THEN V17820=.;
IF V17821=9 THEN V17821=.;
IF V17822=9 THEN V17822=.;
IF V17823=9 THEN V17823=.;
IF V17824=9 THEN V17824=.;
IF V17825=9 THEN V17825=.;
IF V17843=99 THEN V17843=.;
IF V17845=99 THEN V17845=.;
IF V17847=99 THEN V17847=.;
IF V17852=99999 THEN V17852=.;
IF V17853=99999 THEN V17853=.;
IF V17854=99999 THEN V17854=.;
IF V17861=99 THEN V17861=.;
IF V17864=99 THEN V17864=.;
IF V17866=9 THEN V17866=.;
IF V17867=99 THEN V17867=.;
IF V17869=99 THEN V17869=.;
IF V17871=9 THEN V17871=.;
IF V17874=99 THEN V17874=.;
IF V17876=99 THEN V17876=.;
IF V17878=99 THEN V17878=.;
IF V17882=99 THEN V17882=.;
IF V17885=99 THEN V17885=.;
IF V17887=9 THEN V17887=.;
IF V17888=99 THEN V17888=.;
IF V17890=99 THEN V17890=.;
IF V17894=99 THEN V17894=.;
IF V17896=99 THEN V17896=.;
IF V17898=99 THEN V17898=.;
IF V17902=9 THEN V17902=.;
IF V17903=9 THEN V17903=.;
IF V17904=9 THEN V17904=.;
IF V17905=9 THEN V17905=.;
IF V17906=9 THEN V17906=.;
IF V17907=9 THEN V17907=.;
IF V17908=9 THEN V17908=.;
IF V17909=9 THEN V17909=.;
IF V17910=9 THEN V17910=.;
IF V17911=9 THEN V17911=.;
IF V17912=9 THEN V17912=.;
IF V17913=9 THEN V17913=.;
IF V17914=9 THEN V17914=.;
IF V17915=9 THEN V17915=.;
IF V17916=9 THEN V17916=.;
IF V17917=9 THEN V17917=.;
IF V17918=9 THEN V17918=.;
IF V17919=9 THEN V17919=.;
IF V17920=9 THEN V17920=.;
IF V17921=9 THEN V17921=.;
IF V17922=9 THEN V17922=.;
IF V17923=9 THEN V17923=.;
IF V17924=9 THEN V17924=.;
IF V17925=9 THEN V17925=.;
IF V17926=9 THEN V17926=.;
IF V17927=9 THEN V17927=.;
IF V17928=9 THEN V17928=.;
IF V17929=9 THEN V17929=.;
IF V17930=9 THEN V17930=.;
IF V17931=9 THEN V17931=.;
IF V17932=9 THEN V17932=.;
IF V17933=9 THEN V17933=.;
IF V17934=9 THEN V17934=.;
IF V17935=9 THEN V17935=.;
IF V17936=9 THEN V17936=.;
IF V17937=9 THEN V17937=.;
IF V17938=9 THEN V17938=.;
IF V17939=9 THEN V17939=.;
IF V17940=9 THEN V17940=.;
IF V17941=9 THEN V17941=.;
IF V17942=9 THEN V17942=.;
IF V17943=9 THEN V17943=.;
IF V17944=9 THEN V17944=.;
IF V17945=9 THEN V17945=.;
IF V17946=9 THEN V17946=.;
IF V17947=9 THEN V17947=.;
IF V17948=9 THEN V17948=.;
IF V17949=9 THEN V17949=.;
IF V17950=9 THEN V17950=.;
IF V17951=9 THEN V17951=.;
IF V17952=9 THEN V17952=.;
IF V17953=9 THEN V17953=.;
IF V17954=9 THEN V17954=.;
IF V17955=9 THEN V17955=.;
IF V17956=9 THEN V17956=.;
IF V17957=9 THEN V17957=.;
IF V17958=9 THEN V17958=.;
IF V17959=9 THEN V17959=.;
IF V17960=9 THEN V17960=.;
IF V17961=9 THEN V17961=.;
IF V17962=9 THEN V17962=.;
IF V17963=9 THEN V17963=.;
IF V17964=9 THEN V17964=.;
IF V17965=9 THEN V17965=.;
IF V17966=9 THEN V17966=.;
IF V17967=9 THEN V17967=.;
IF V17968=9 THEN V17968=.;
IF V17969=9 THEN V17969=.;
IF V17970=9 THEN V17970=.;
IF V17971=9 THEN V17971=.;
IF V17972=9 THEN V17972=.;
IF V17973=9 THEN V17973=.;
IF V18044=9999 THEN V18044=.;
IF V18045=999 THEN V18045=.;
IF V18046=9999 THEN V18046=.;
IF V18047=999 THEN V18047=.;
IF V18049=99 THEN V18049=.;
IF V18051=99 THEN V18051=.;
IF V18053=99 THEN V18053=.;
IF V18054=99 THEN V18054=.;
IF V18055=9 THEN V18055=.;
IF V18056=9 THEN V18056=.;
IF V18057=9 THEN V18057=.;
IF V18058=9 THEN V18058=.;
IF V18059=9 THEN V18059=.;
IF V18060=9 THEN V18060=.;
IF V18061=9 THEN V18061=.;
IF V18062=9 THEN V18062=.;
IF V18063=9 THEN V18063=.;
IF V18064=9 THEN V18064=.;
IF V18065=9 THEN V18065=.;
IF V18066=9 THEN V18066=.;
IF V18067=9 THEN V18067=.;
IF V18068=99 THEN V18068=.;
IF V18070=99 THEN V18070=.;
IF V18071=9 THEN V18071=.;
IF V18073=9 THEN V18073=.;
IF V18074=99 THEN V18074=.;
IF V18075=9 THEN V18075=.;
IF V18076=9 THEN V18076=.;
IF V18077=9 THEN V18077=.;
IF V18078=9 THEN V18078=.;
IF V18079=9 THEN V18079=.;
IF V18080=9 THEN V18080=.;
IF V18081=9 THEN V18081=.;
IF V18082=9 THEN V18082=.;
IF V18083=9 THEN V18083=.;
IF V18084=9 THEN V18084=.;
IF V18085=9 THEN V18085=.;
IF V18086=9 THEN V18086=.;
IF V18087=9 THEN V18087=.;
IF V18088=99 THEN V18088=.;
IF V18089=9 THEN V18089=.;
IF V18090=9 THEN V18090=.;
IF V18091=9 THEN V18091=.;
IF V18092=9 THEN V18092=.;
IF V18094=99 THEN V18094=.;
IF V18095=9 THEN V18095=.;
IF V18096=9 THEN V18096=.;
IF V18097=9 THEN V18097=.;
IF V18098=9 THEN V18098=.;
IF V18099=9 THEN V18099=.;
IF V18100=9 THEN V18100=.;
IF V18101=999 THEN V18101=.;
IF V18102=999 THEN V18102=.;
IF V18103=9 THEN V18103=.;
IF V18104=9999 THEN V18104=.;
IF V18105=9 THEN V18105=.;
IF V18106=9999 THEN V18106=.;
IF V18107=9999 THEN V18107=.;
IF V18108=9999 THEN V18108=.;
IF V18109=9 THEN V18109=.;
IF V18110=9999 THEN V18110=.;
IF V18111=9 THEN V18111=.;
IF V18112=9 THEN V18112=.;
IF V18113=9 THEN V18113=.;
IF V18114=9 THEN V18114=.;
IF V18115=9 THEN V18115=.;
IF V18116=9 THEN V18116=.;
IF V18117=9 THEN V18117=.;
IF V18118=9 THEN V18118=.;
IF V18119=9 THEN V18119=.;
IF V18120=999 THEN V18120=.;
IF V18121=99 THEN V18121=.;
IF V18122=99 THEN V18122=.;
IF V18123=9 THEN V18123=.;
IF V18124=99 THEN V18124=.;
IF V18125=99 THEN V18125=.;
IF V18126=9 THEN V18126=.;
IF V18127=99 THEN V18127=.;
IF V18128=9 THEN V18128=.;
IF V18129=99 THEN V18129=.;
IF V18130=99 THEN V18130=.;
IF V18131=99 THEN V18131=.;
IF V18132=99 THEN V18132=.;
IF V18133=9 THEN V18133=.;
IF V18134=99 THEN V18134=.;
IF V18135=9 THEN V18135=.;
IF V18136=999 THEN V18136=.;
IF V18137=9999 THEN V18137=.;
IF V18138=99 THEN V18138=.;
IF V18139=9 THEN V18139=.;
IF V18140=9 THEN V18140=.;
IF V18141=9 THEN V18141=.;
IF V18142=9 THEN V18142=.;
IF V18143=9 THEN V18143=.;
IF V18144=9 THEN V18144=.;
IF V18145=9 THEN V18145=.;
IF V18146=9 THEN V18146=.;
IF V18147=9 THEN V18147=.;
IF V18148=9 THEN V18148=.;
IF V18149=9 THEN V18149=.;
IF V18150=9 THEN V18150=.;
IF V18151=9 THEN V18151=.;
IF V18152=99 THEN V18152=.;
IF V18153=99 THEN V18153=.;
IF V18154=9 THEN V18154=.;
IF V18155=9 THEN V18155=.;
IF V18156=9 THEN V18156=.;
IF V18157=9 THEN V18157=.;
IF V18158=9 THEN V18158=.;
IF V18159=9 THEN V18159=.;
IF V18160=9 THEN V18160=.;
IF V18161=9 THEN V18161=.;
IF V18162=9 THEN V18162=.;
IF V18163=9 THEN V18163=.;
IF V18164=9 THEN V18164=.;
IF V18165=9 THEN V18165=.;
IF V18166=9 THEN V18166=.;
IF V18167=9 THEN V18167=.;
IF V18168=9 THEN V18168=.;
IF V18169=999 THEN V18169=.;
IF V18170=999 THEN V18170=.;
IF V18171=9999 THEN V18171=.;
IF V18172=99 THEN V18172=.;
IF V18173=9 THEN V18173=.;
IF V18174=99 THEN V18174=.;
IF V18175=9 THEN V18175=.;
IF V18176=9 THEN V18176=.;
IF V18177=99 THEN V18177=.;
IF V18178=99 THEN V18178=.;
IF V18179=9 THEN V18179=.;
IF V18180=9999 THEN V18180=.;
IF V18181=99 THEN V18181=.;
IF V18182=9 THEN V18182=.;
IF V18184=9 THEN V18184=.;
IF V18185=99 THEN V18185=.;
IF V18186=9 THEN V18186=.;
IF V18187=99 THEN V18187=.;
IF V18188=9 THEN V18188=.;
IF V18189=99 THEN V18189=.;
IF V18190=9 THEN V18190=.;
IF V18191=99 THEN V18191=.;
IF V18192=9 THEN V18192=.;
IF V18193=99 THEN V18193=.;
IF V18194=9 THEN V18194=.;
IF V18195=99 THEN V18195=.;
IF V18196=99 THEN V18196=.;
IF V18197=99 THEN V18197=.;
IF V18198=9 THEN V18198=.;
IF V18199=9 THEN V18199=.;
IF V18200=9 THEN V18200=.;
IF V18201=9 THEN V18201=.;
IF V18202=999 THEN V18202=.;
IF V18203=999 THEN V18203=.;
IF V18204=9999 THEN V18204=.;
IF V18205=99 THEN V18205=.;
IF V18206=99 THEN V18206=.;
IF V18207=99 THEN V18207=.;
IF V18208=99 THEN V18208=.;
IF V18209=9 THEN V18209=.;
IF V18210=9 THEN V18210=.;
IF V18211=9 THEN V18211=.;
IF V18212=9 THEN V18212=.;
IF V18213=9 THEN V18213=.;
IF V18214=9 THEN V18214=.;
IF V18215=9 THEN V18215=.;
IF V18216=9 THEN V18216=.;
IF V18217=9 THEN V18217=.;
IF V18218=9 THEN V18218=.;
IF V18219=9 THEN V18219=.;
IF V18220=9 THEN V18220=.;
IF V18221=9 THEN V18221=.;
IF V18222=99 THEN V18222=.;
IF V18223=99 THEN V18223=.;
IF V18224=9 THEN V18224=.;
IF V18225=999 THEN V18225=.;
IF V18226=999 THEN V18226=.;
IF V18227=9999 THEN V18227=.;
IF V18228=99 THEN V18228=.;
IF V18229=99 THEN V18229=.;
IF V18230=99 THEN V18230=.;
IF V18231=99 THEN V18231=.;
IF V18232=9 THEN V18232=.;
IF V18233=9 THEN V18233=.;
IF V18234=9 THEN V18234=.;
IF V18235=9 THEN V18235=.;
IF V18236=9 THEN V18236=.;
IF V18237=9 THEN V18237=.;
IF V18238=9 THEN V18238=.;
IF V18239=9 THEN V18239=.;
IF V18240=9 THEN V18240=.;
IF V18241=9 THEN V18241=.;
IF V18242=9 THEN V18242=.;
IF V18243=9 THEN V18243=.;
IF V18244=9 THEN V18244=.;
IF V18245=99 THEN V18245=.;
IF V18246=99 THEN V18246=.;
IF V18247=9 THEN V18247=.;
IF V18248=9 THEN V18248=.;
IF V18249=9 THEN V18249=.;
IF V18250=9 THEN V18250=.;
IF V18251=9 THEN V18251=.;
IF V18252=9 THEN V18252=.;
IF V18253=9 THEN V18253=.;
IF V18254=9 THEN V18254=.;
IF V18255=9 THEN V18255=.;
IF V18256=99 THEN V18256=.;
IF V18257=9 THEN V18257=.;
IF V18258=99 THEN V18258=.;
IF V18259=99 THEN V18259=.;
IF V18260=9 THEN V18260=.;
IF V18261=99 THEN V18261=.;
IF V18262=999 THEN V18262=.;
IF V18263=999 THEN V18263=.;
IF V18264=9 THEN V18264=.;
IF V18265=9 THEN V18265=.;
IF V18266=9 THEN V18266=.;
IF V18267=9 THEN V18267=.;
IF V18268=99 THEN V18268=.;
IF V18269=99 THEN V18269=.;
IF V18270=9 THEN V18270=.;
IF V18271=99 THEN V18271=.;
IF V18272=99 THEN V18272=.;
IF V18273=9 THEN V18273=.;
IF V18274=99 THEN V18274=.;
IF V18275=9 THEN V18275=.;
IF V18276=99 THEN V18276=.;
IF V18277=99 THEN V18277=.;
IF V18278=99 THEN V18278=.;
IF V18279=99 THEN V18279=.;
IF V18280=9 THEN V18280=.;
IF V18281=99 THEN V18281=.;
IF V18282=9 THEN V18282=.;
IF V18283=999 THEN V18283=.;
IF V18284=9999 THEN V18284=.;
IF V18285=99 THEN V18285=.;
IF V18286=9 THEN V18286=.;
IF V18287=9 THEN V18287=.;
IF V18288=9 THEN V18288=.;
IF V18289=9 THEN V18289=.;
IF V18290=9 THEN V18290=.;
IF V18291=9 THEN V18291=.;
IF V18292=9 THEN V18292=.;
IF V18293=9 THEN V18293=.;
IF V18294=9 THEN V18294=.;
IF V18295=9 THEN V18295=.;
IF V18296=9 THEN V18296=.;
IF V18297=9 THEN V18297=.;
IF V18298=9 THEN V18298=.;
IF V18299=99 THEN V18299=.;
IF V18300=99 THEN V18300=.;
IF V18301=9 THEN V18301=.;
IF V18302=9 THEN V18302=.;
IF V18303=9 THEN V18303=.;
IF V18304=9 THEN V18304=.;
IF V18305=9 THEN V18305=.;
IF V18306=9 THEN V18306=.;
IF V18307=9 THEN V18307=.;
IF V18308=9 THEN V18308=.;
IF V18309=9 THEN V18309=.;
IF V18310=9 THEN V18310=.;
IF V18311=9 THEN V18311=.;
IF V18312=9 THEN V18312=.;
IF V18313=9 THEN V18313=.;
IF V18314=9 THEN V18314=.;
IF V18315=9 THEN V18315=.;
IF V18316=999 THEN V18316=.;
IF V18317=999 THEN V18317=.;
IF V18318=9999 THEN V18318=.;
IF V18319=99 THEN V18319=.;
IF V18320=9 THEN V18320=.;
IF V18321=99 THEN V18321=.;
IF V18322=9 THEN V18322=.;
IF V18323=9 THEN V18323=.;
IF V18324=99 THEN V18324=.;
IF V18325=99 THEN V18325=.;
IF V18326=9 THEN V18326=.;
IF V18327=9999 THEN V18327=.;
IF V18328=99 THEN V18328=.;
IF V18329=9 THEN V18329=.;
IF V18331=9 THEN V18331=.;
IF V18332=99 THEN V18332=.;
IF V18333=9 THEN V18333=.;
IF V18334=99 THEN V18334=.;
IF V18335=9 THEN V18335=.;
IF V18336=99 THEN V18336=.;
IF V18337=9 THEN V18337=.;
IF V18338=99 THEN V18338=.;
IF V18339=9 THEN V18339=.;
IF V18340=99 THEN V18340=.;
IF V18341=9 THEN V18341=.;
IF V18342=99 THEN V18342=.;
IF V18343=99 THEN V18343=.;
IF V18344=99 THEN V18344=.;
IF V18345=9 THEN V18345=.;
IF V18346=9 THEN V18346=.;
IF V18347=9 THEN V18347=.;
IF V18348=9 THEN V18348=.;
IF V18349=999 THEN V18349=.;
IF V18350=999 THEN V18350=.;
IF V18351=9999 THEN V18351=.;
IF V18352=99 THEN V18352=.;
IF V18353=99 THEN V18353=.;
IF V18354=99 THEN V18354=.;
IF V18355=99 THEN V18355=.;
IF V18356=9 THEN V18356=.;
IF V18357=9 THEN V18357=.;
IF V18358=9 THEN V18358=.;
IF V18359=9 THEN V18359=.;
IF V18360=9 THEN V18360=.;
IF V18361=9 THEN V18361=.;
IF V18362=9 THEN V18362=.;
IF V18363=9 THEN V18363=.;
IF V18364=9 THEN V18364=.;
IF V18365=9 THEN V18365=.;
IF V18366=9 THEN V18366=.;
IF V18367=9 THEN V18367=.;
IF V18368=9 THEN V18368=.;
IF V18369=99 THEN V18369=.;
IF V18370=99 THEN V18370=.;
IF V18371=9 THEN V18371=.;
IF V18372=999 THEN V18372=.;
IF V18373=999 THEN V18373=.;
IF V18374=9999 THEN V18374=.;
IF V18375=99 THEN V18375=.;
IF V18376=99 THEN V18376=.;
IF V18377=99 THEN V18377=.;
IF V18378=99 THEN V18378=.;
IF V18379=9 THEN V18379=.;
IF V18380=9 THEN V18380=.;
IF V18381=9 THEN V18381=.;
IF V18382=9 THEN V18382=.;
IF V18383=9 THEN V18383=.;
IF V18384=9 THEN V18384=.;
IF V18385=9 THEN V18385=.;
IF V18386=9 THEN V18386=.;
IF V18387=9 THEN V18387=.;
IF V18388=9 THEN V18388=.;
IF V18389=9 THEN V18389=.;
IF V18390=9 THEN V18390=.;
IF V18391=9 THEN V18391=.;
IF V18392=99 THEN V18392=.;
IF V18393=99 THEN V18393=.;
IF V18396=99 THEN V18396=.;
IF V18397=9 THEN V18397=.;
IF V18398=9 THEN V18398=.;
IF V18399=9 THEN V18399=.;
IF V18400=9 THEN V18400=.;
IF V18401=9 THEN V18401=.;
IF V18402=9 THEN V18402=.;
IF V18403=999 THEN V18403=.;
IF V18404=999 THEN V18404=.;
IF V18405=9 THEN V18405=.;
IF V18406=9999 THEN V18406=.;
IF V18407=9 THEN V18407=.;
IF V18408=9999 THEN V18408=.;
IF V18409=9999 THEN V18409=.;
IF V18410=9999 THEN V18410=.;
IF V18411=9 THEN V18411=.;
IF V18412=9999 THEN V18412=.;
IF V18413=9 THEN V18413=.;
IF V18414=9 THEN V18414=.;
IF V18415=9 THEN V18415=.;
IF V18416=9 THEN V18416=.;
IF V18417=9 THEN V18417=.;
IF V18418=9 THEN V18418=.;
IF V18419=9 THEN V18419=.;
IF V18420=9 THEN V18420=.;
IF V18421=9 THEN V18421=.;
IF V18422=999 THEN V18422=.;
IF V18423=99 THEN V18423=.;
IF V18424=99 THEN V18424=.;
IF V18425=9 THEN V18425=.;
IF V18426=99 THEN V18426=.;
IF V18427=99 THEN V18427=.;
IF V18428=9 THEN V18428=.;
IF V18429=99 THEN V18429=.;
IF V18430=9 THEN V18430=.;
IF V18431=99 THEN V18431=.;
IF V18432=99 THEN V18432=.;
IF V18433=99 THEN V18433=.;
IF V18434=99 THEN V18434=.;
IF V18435=9 THEN V18435=.;
IF V18436=99 THEN V18436=.;
IF V18437=9 THEN V18437=.;
IF V18438=999 THEN V18438=.;
IF V18439=9999 THEN V18439=.;
IF V18440=99 THEN V18440=.;
IF V18441=9 THEN V18441=.;
IF V18442=9 THEN V18442=.;
IF V18443=9 THEN V18443=.;
IF V18444=9 THEN V18444=.;
IF V18445=9 THEN V18445=.;
IF V18446=9 THEN V18446=.;
IF V18447=9 THEN V18447=.;
IF V18448=9 THEN V18448=.;
IF V18449=9 THEN V18449=.;
IF V18450=9 THEN V18450=.;
IF V18451=9 THEN V18451=.;
IF V18452=9 THEN V18452=.;
IF V18453=9 THEN V18453=.;
IF V18454=99 THEN V18454=.;
IF V18455=99 THEN V18455=.;
IF V18456=9 THEN V18456=.;
IF V18457=9 THEN V18457=.;
IF V18458=9 THEN V18458=.;
IF V18459=9 THEN V18459=.;
IF V18460=9 THEN V18460=.;
IF V18461=9 THEN V18461=.;
IF V18462=9 THEN V18462=.;
IF V18463=9 THEN V18463=.;
IF V18464=9 THEN V18464=.;
IF V18465=9 THEN V18465=.;
IF V18466=9 THEN V18466=.;
IF V18467=9 THEN V18467=.;
IF V18468=9 THEN V18468=.;
IF V18469=9 THEN V18469=.;
IF V18470=9 THEN V18470=.;
IF V18471=999 THEN V18471=.;
IF V18472=999 THEN V18472=.;
IF V18473=9999 THEN V18473=.;
IF V18474=99 THEN V18474=.;
IF V18475=9 THEN V18475=.;
IF V18476=99 THEN V18476=.;
IF V18477=9 THEN V18477=.;
IF V18478=9 THEN V18478=.;
IF V18479=99 THEN V18479=.;
IF V18480=99 THEN V18480=.;
IF V18481=9 THEN V18481=.;
IF V18482=9999 THEN V18482=.;
IF V18483=99 THEN V18483=.;
IF V18484=9 THEN V18484=.;
IF V18486=9 THEN V18486=.;
IF V18487=99 THEN V18487=.;
IF V18488=9 THEN V18488=.;
IF V18489=99 THEN V18489=.;
IF V18490=9 THEN V18490=.;
IF V18491=99 THEN V18491=.;
IF V18492=9 THEN V18492=.;
IF V18493=99 THEN V18493=.;
IF V18494=9 THEN V18494=.;
IF V18495=99 THEN V18495=.;
IF V18496=9 THEN V18496=.;
IF V18497=99 THEN V18497=.;
IF V18498=99 THEN V18498=.;
IF V18499=99 THEN V18499=.;
IF V18500=9 THEN V18500=.;
IF V18501=9 THEN V18501=.;
IF V18502=9 THEN V18502=.;
IF V18503=9 THEN V18503=.;
IF V18504=999 THEN V18504=.;
IF V18505=999 THEN V18505=.;
IF V18506=9999 THEN V18506=.;
IF V18507=99 THEN V18507=.;
IF V18508=99 THEN V18508=.;
IF V18509=99 THEN V18509=.;
IF V18510=99 THEN V18510=.;
IF V18511=9 THEN V18511=.;
IF V18512=9 THEN V18512=.;
IF V18513=9 THEN V18513=.;
IF V18514=9 THEN V18514=.;
IF V18515=9 THEN V18515=.;
IF V18516=9 THEN V18516=.;
IF V18517=9 THEN V18517=.;
IF V18518=9 THEN V18518=.;
IF V18519=9 THEN V18519=.;
IF V18520=9 THEN V18520=.;
IF V18521=9 THEN V18521=.;
IF V18522=9 THEN V18522=.;
IF V18523=9 THEN V18523=.;
IF V18524=99 THEN V18524=.;
IF V18525=99 THEN V18525=.;
IF V18526=9 THEN V18526=.;
IF V18527=999 THEN V18527=.;
IF V18528=999 THEN V18528=.;
IF V18529=9999 THEN V18529=.;
IF V18530=99 THEN V18530=.;
IF V18531=99 THEN V18531=.;
IF V18532=99 THEN V18532=.;
IF V18533=99 THEN V18533=.;
IF V18534=9 THEN V18534=.;
IF V18535=9 THEN V18535=.;
IF V18536=9 THEN V18536=.;
IF V18537=9 THEN V18537=.;
IF V18538=9 THEN V18538=.;
IF V18539=9 THEN V18539=.;
IF V18540=9 THEN V18540=.;
IF V18541=9 THEN V18541=.;
IF V18542=9 THEN V18542=.;
IF V18543=9 THEN V18543=.;
IF V18544=9 THEN V18544=.;
IF V18545=9 THEN V18545=.;
IF V18546=9 THEN V18546=.;
IF V18547=99 THEN V18547=.;
IF V18548=99 THEN V18548=.;
IF V18549=9 THEN V18549=.;
IF V18550=9 THEN V18550=.;
IF V18551=9 THEN V18551=.;
IF V18552=9 THEN V18552=.;
IF V18553=9 THEN V18553=.;
IF V18554=9 THEN V18554=.;
IF V18555=9 THEN V18555=.;
IF V18556=9 THEN V18556=.;
IF V18557=9 THEN V18557=.;
IF V18558=99 THEN V18558=.;
IF V18559=9 THEN V18559=.;
IF V18560=99 THEN V18560=.;
IF V18561=99 THEN V18561=.;
IF V18562=9 THEN V18562=.;
IF V18563=99 THEN V18563=.;
IF V18564=999 THEN V18564=.;
IF V18565=999 THEN V18565=.;
IF V18566=9 THEN V18566=.;
IF V18567=9 THEN V18567=.;
IF V18568=9 THEN V18568=.;
IF V18569=9 THEN V18569=.;
IF V18570=99 THEN V18570=.;
IF V18571=99 THEN V18571=.;
IF V18572=9 THEN V18572=.;
IF V18573=99 THEN V18573=.;
IF V18574=99 THEN V18574=.;
IF V18575=9 THEN V18575=.;
IF V18576=99 THEN V18576=.;
IF V18577=9 THEN V18577=.;
IF V18578=99 THEN V18578=.;
IF V18579=99 THEN V18579=.;
IF V18580=99 THEN V18580=.;
IF V18581=99 THEN V18581=.;
IF V18582=9 THEN V18582=.;
IF V18583=99 THEN V18583=.;
IF V18584=9 THEN V18584=.;
IF V18585=999 THEN V18585=.;
IF V18586=9999 THEN V18586=.;
IF V18587=99 THEN V18587=.;
IF V18588=9 THEN V18588=.;
IF V18589=9 THEN V18589=.;
IF V18590=9 THEN V18590=.;
IF V18591=9 THEN V18591=.;
IF V18592=9 THEN V18592=.;
IF V18593=9 THEN V18593=.;
IF V18594=9 THEN V18594=.;
IF V18595=9 THEN V18595=.;
IF V18596=9 THEN V18596=.;
IF V18597=9 THEN V18597=.;
IF V18598=9 THEN V18598=.;
IF V18599=9 THEN V18599=.;
IF V18600=9 THEN V18600=.;
IF V18601=99 THEN V18601=.;
IF V18602=99 THEN V18602=.;
IF V18603=9 THEN V18603=.;
IF V18604=9 THEN V18604=.;
IF V18605=9 THEN V18605=.;
IF V18606=9 THEN V18606=.;
IF V18607=9 THEN V18607=.;
IF V18608=9 THEN V18608=.;
IF V18609=9 THEN V18609=.;
IF V18610=9 THEN V18610=.;
IF V18611=9 THEN V18611=.;
IF V18612=9 THEN V18612=.;
IF V18613=9 THEN V18613=.;
IF V18614=9 THEN V18614=.;
IF V18615=9 THEN V18615=.;
IF V18616=9 THEN V18616=.;
IF V18617=9 THEN V18617=.;
IF V18618=999 THEN V18618=.;
IF V18619=999 THEN V18619=.;
IF V18620=9999 THEN V18620=.;
IF V18621=99 THEN V18621=.;
IF V18622=9 THEN V18622=.;
IF V18623=99 THEN V18623=.;
IF V18624=9 THEN V18624=.;
IF V18625=9 THEN V18625=.;
IF V18626=99 THEN V18626=.;
IF V18627=99 THEN V18627=.;
IF V18628=9 THEN V18628=.;
IF V18629=9999 THEN V18629=.;
IF V18630=99 THEN V18630=.;
IF V18631=9 THEN V18631=.;
IF V18633=9 THEN V18633=.;
IF V18634=99 THEN V18634=.;
IF V18635=9 THEN V18635=.;
IF V18636=99 THEN V18636=.;
IF V18637=9 THEN V18637=.;
IF V18638=99 THEN V18638=.;
IF V18639=9 THEN V18639=.;
IF V18640=99 THEN V18640=.;
IF V18641=9 THEN V18641=.;
IF V18642=99 THEN V18642=.;
IF V18643=9 THEN V18643=.;
IF V18644=99 THEN V18644=.;
IF V18645=99 THEN V18645=.;
IF V18646=99 THEN V18646=.;
IF V18647=9 THEN V18647=.;
IF V18648=9 THEN V18648=.;
IF V18649=9 THEN V18649=.;
IF V18650=9 THEN V18650=.;
IF V18651=999 THEN V18651=.;
IF V18652=999 THEN V18652=.;
IF V18653=9999 THEN V18653=.;
IF V18654=99 THEN V18654=.;
IF V18655=99 THEN V18655=.;
IF V18656=99 THEN V18656=.;
IF V18657=99 THEN V18657=.;
IF V18658=9 THEN V18658=.;
IF V18659=9 THEN V18659=.;
IF V18660=9 THEN V18660=.;
IF V18661=9 THEN V18661=.;
IF V18662=9 THEN V18662=.;
IF V18663=9 THEN V18663=.;
IF V18664=9 THEN V18664=.;
IF V18665=9 THEN V18665=.;
IF V18666=9 THEN V18666=.;
IF V18667=9 THEN V18667=.;
IF V18668=9 THEN V18668=.;
IF V18669=9 THEN V18669=.;
IF V18670=9 THEN V18670=.;
IF V18671=99 THEN V18671=.;
IF V18672=99 THEN V18672=.;
IF V18673=9 THEN V18673=.;
IF V18674=999 THEN V18674=.;
IF V18675=999 THEN V18675=.;
IF V18676=9999 THEN V18676=.;
IF V18677=99 THEN V18677=.;
IF V18678=99 THEN V18678=.;
IF V18679=99 THEN V18679=.;
IF V18680=99 THEN V18680=.;
IF V18681=9 THEN V18681=.;
IF V18682=9 THEN V18682=.;
IF V18683=9 THEN V18683=.;
IF V18684=9 THEN V18684=.;
IF V18685=9 THEN V18685=.;
IF V18686=9 THEN V18686=.;
IF V18687=9 THEN V18687=.;
IF V18688=9 THEN V18688=.;
IF V18689=9 THEN V18689=.;
IF V18690=9 THEN V18690=.;
IF V18691=9 THEN V18691=.;
IF V18692=9 THEN V18692=.;
IF V18693=9 THEN V18693=.;
IF V18694=99 THEN V18694=.;
IF V18695=99 THEN V18695=.;
IF V18697=99 THEN V18697=.;
IF V18698=99 THEN V18698=.;
IF V18699=9 THEN V18699=.;
IF V18700=99999 THEN V18700=.;
IF V18701=9 THEN V18701=.;
IF V18702=999999 THEN V18702=.;
IF V18703=9 THEN V18703=.;
IF V18704=99 THEN V18704=.;
IF V18705=9 THEN V18705=.;
IF V18706=9 THEN V18706=.;
IF V18707=9 THEN V18707=.;
IF V18708=9 THEN V18708=.;
IF V18709=999999 THEN V18709=.;
IF V18710=999999 THEN V18710=.;
IF V18711=9 THEN V18711=.;
IF V18712=9 THEN V18712=.;
IF V18713=99 THEN V18713=.;
IF V18714=99 THEN V18714=.;
IF V18715=99 THEN V18715=.;
IF V18716=99 THEN V18716=.;
IF V18717=9 THEN V18717=.;
IF V18718=9 THEN V18718=.;
IF V18719=9 THEN V18719=.;
IF V18720=9 THEN V18720=.;
IF V18721=9 THEN V18721=.;
IF V18722=9 THEN V18722=.;
IF V18723=9 THEN V18723=.;
IF V18724=9 THEN V18724=.;
IF V18725=9 THEN V18725=.;
IF V18727=9 THEN V18727=.;
IF V18728=9 THEN V18728=.;
IF V18729=9 THEN V18729=.;
IF V18730=9 THEN V18730=.;
IF V18732=9 THEN V18732=.;
IF V18734=9 THEN V18734=.;
IF V18735=9 THEN V18735=.;
IF V18736=9 THEN V18736=.;
IF V18737=99 THEN V18737=.;
IF V18738=9 THEN V18738=.;
IF V18739=9 THEN V18739=.;
IF V18740=99 THEN V18740=.;
IF V18741=9 THEN V18741=.;
IF V18742=9 THEN V18742=.;
IF V18743=99 THEN V18743=.;
IF V18744=9 THEN V18744=.;
IF V18745=9 THEN V18745=.;
IF V18746=99 THEN V18746=.;
IF V18747=9 THEN V18747=.;
IF V18748=9 THEN V18748=.;
IF V18749=9 THEN V18749=.;
IF V18750=9 THEN V18750=.;
IF V18751=9 THEN V18751=.;
IF V18752=9 THEN V18752=.;
IF V18753=99 THEN V18753=.;
IF V18754=99 THEN V18754=.;
IF V18755=99 THEN V18755=.;
IF V18756=99 THEN V18756=.;
IF V18757=99 THEN V18757=.;
IF V18758=99 THEN V18758=.;
IF V18759=9 THEN V18759=.;
IF V18760=99 THEN V18760=.;
IF V18761=9 THEN V18761=.;
IF V18762=9 THEN V18762=.;
IF V18763=99 THEN V18763=.;
IF V18764=99 THEN V18764=.;
IF V18765=9 THEN V18765=.;
IF V18766=9 THEN V18766=.;
IF V18767=9 THEN V18767=.;
IF V18768=99 THEN V18768=.;
IF V18769=99 THEN V18769=.;
IF V18770=99 THEN V18770=.;
IF V18771=9 THEN V18771=.;
IF V18772=99 THEN V18772=.;
IF V18773=99 THEN V18773=.;
IF V18774=99 THEN V18774=.;
IF V18775=9 THEN V18775=.;
IF V18776=99 THEN V18776=.;
IF V18777=99 THEN V18777=.;
IF V18778=99 THEN V18778=.;
IF V18779=99 THEN V18779=.;
IF V18780=99 THEN V18780=.;
IF V18781=99 THEN V18781=.;
IF V18783=99 THEN V18783=.;
IF V18784=999 THEN V18784=.;
IF V18785=99 THEN V18785=.;
IF V18786=999 THEN V18786=.;
IF V18787=9 THEN V18787=.;
IF V18788=9 THEN V18788=.;
IF V18789=9 THEN V18789=.;
IF V18790=9 THEN V18790=.;
IF V18791=99 THEN V18791=.;
IF V18792=999 THEN V18792=.;
IF V18793=9 THEN V18793=.;
IF V18794=9 THEN V18794=.;
IF V18795=9 THEN V18795=.;
IF V18796=9 THEN V18796=.;
IF V18797=9 THEN V18797=.;
IF V18798=9 THEN V18798=.;
IF V18799=9 THEN V18799=.;
IF V18800=9 THEN V18800=.;
IF V18801=99 THEN V18801=.;
IF V18802=9 THEN V18802=.;
IF V18803=9 THEN V18803=.;
IF V18804=99 THEN V18804=.;
IF V18805=9 THEN V18805=.;
IF V18806=9 THEN V18806=.;
IF V18807=99 THEN V18807=.;
IF V18808=9 THEN V18808=.;
IF V18809=9 THEN V18809=.;
IF V18810=99 THEN V18810=.;
IF V18811=9 THEN V18811=.;
IF V18812=9 THEN V18812=.;
IF V18813=9 THEN V18813=.;
IF V18814=9 THEN V18814=.;
IF V18815=9 THEN V18815=.;
IF V18816=9 THEN V18816=.;
IF V18817=9 THEN V18817=.;
IF V18818=99 THEN V18818=.;
IF V18819=99 THEN V18819=.;
IF V18820=99 THEN V18820=.;
IF V18821=99 THEN V18821=.;
IF V18822=99 THEN V18822=.;
IF V18823=99 THEN V18823=.;
IF V18824=99 THEN V18824=.;
IF V18825=99 THEN V18825=.;
IF V18826=99 THEN V18826=.;
IF V18827=99 THEN V18827=.;
IF V18828=9 THEN V18828=.;
IF V18829=99 THEN V18829=.;
IF V18830=99 THEN V18830=.;
IF V18831=9 THEN V18831=.;
IF V18832=9 THEN V18832=.;
IF V18833=99 THEN V18833=.;
IF V18834=99 THEN V18834=.;
IF V18835=99 THEN V18835=.;
IF V18836=9 THEN V18836=.;
IF V18837=9 THEN V18837=.;
IF V18838=9 THEN V18838=.;
IF V18839=99 THEN V18839=.;
IF V18840=99 THEN V18840=.;
IF V18841=99 THEN V18841=.;
IF V18842=99 THEN V18842=.;
IF V18843=9 THEN V18843=.;
IF V18844=99 THEN V18844=.;
IF V18845=99 THEN V18845=.;
IF V18846=99 THEN V18846=.;
IF V18847=99 THEN V18847=.;
IF V18848=9 THEN V18848=.;
IF V18849=99 THEN V18849=.;
IF V18850=99 THEN V18850=.;
IF V18851=99 THEN V18851=.;
IF V18852=99 THEN V18852=.;
IF V18853=99 THEN V18853=.;
IF V18854=99 THEN V18854=.;
IF V18855=99 THEN V18855=.;
IF V18856=9 THEN V18856=.;
IF V18857=99 THEN V18857=.;
IF V18858=9 THEN V18858=.;
IF V18859=9 THEN V18859=.;
IF V18860=9 THEN V18860=.;
IF V18889=9 THEN V18889=.;
IF V18890=99 THEN V18890=.;
IF V18891=999 THEN V18891=.;
IF V18892=99 THEN V18892=.;
IF V18893=9 THEN V18893=.;
IF V18894=9 THEN V18894=.;
IF V18898=9 THEN V18898=.;
IF V18899=9 THEN V18899=.;
IF V18915=99 THEN V18915=.;
IF V18919=99 THEN V18919=.;
IF V18937=8 THEN V18937=.;
IF V18938=8 THEN V18938=.;
IF V18939=8 THEN V18939=.;
IF V18940=8 THEN V18940=.;
 
file rawdat lrecl=2333;
put    
v17702
v17710
v17724
v17725
v17726
v17733
v17734
v17744
v17745
v17747
v17774
v17775
v17777
v17805
v17806
v17807
v17808
v17809
v17810
v17811
v17812
v17836
v17844
v17846
v17849
v17851
v17901
v18000
v18001
v18003
v18017
v18046
v18048
v18049
v18050
v18051
v18072
v18073
v18074
v18075
v18087
v18088
v18089
v18093
v18096
v18120
v18196
v18197
v18256
v18267
v18343
v18344
v18395
v18397
v18398
v18422
v18481
v18498
v18499
v18558
v18569
v18645
v18646
v18709
v18713
v18722
v18752
v18759
v18762
v18782
v18814
v18817
v18828
v18832
v18875
v18878
v18882
v18889
v18916
v18943
v30643
;

 proc means;
 run; 
